/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.data.input;

import java.util.List;
import java.util.TreeMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableSortedSet;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.io.druid.data.input.InputRow;
import org.apache.hive.druid.io.druid.data.input.MapBasedInputRow;
import org.apache.hive.druid.io.druid.data.input.MapBasedRow;
import org.apache.hive.druid.io.druid.data.input.Row;
import org.apache.hive.druid.io.druid.java.util.common.ISE;

public class Rows {
    public static InputRow toCaseInsensitiveInputRow(Row row, List<String> dimensions) {
        if (row instanceof MapBasedRow) {
            MapBasedRow mapBasedRow = (MapBasedRow)row;
            TreeMap<String, Object> caseInsensitiveMap = Maps.newTreeMap(String.CASE_INSENSITIVE_ORDER);
            caseInsensitiveMap.putAll(mapBasedRow.getEvent());
            return new MapBasedInputRow(mapBasedRow.getTimestamp(), dimensions, caseInsensitiveMap);
        }
        throw new ISE("Can only convert MapBasedRow objects because we are ghetto like that.", new Object[0]);
    }

    public static List<Object> toGroupKey(long timeStamp, InputRow inputRow) {
        TreeMap<String, ImmutableSortedSet<String>> dims = Maps.newTreeMap();
        for (String dim : inputRow.getDimensions()) {
            ImmutableSortedSet<String> dimValues = ImmutableSortedSet.copyOf(inputRow.getDimension(dim));
            if (dimValues.size() <= 0) continue;
            dims.put(dim, dimValues);
        }
        return ImmutableList.of(Long.valueOf(timeStamp), dims);
    }
}

