/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.data.input;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.data.input.Row;
import org.apache.hive.druid.io.druid.java.util.common.parsers.ParseException;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class MapBasedRow
implements Row {
    private static final Function<Object, String> TO_STRING_INCLUDING_NULL = String::valueOf;
    private final DateTime timestamp;
    private final Map<String, Object> event;
    private static final Pattern LONG_PAT = Pattern.compile("[-|+]?\\d+");

    @JsonCreator
    public MapBasedRow(@JsonProperty(value="timestamp") DateTime timestamp, @JsonProperty(value="event") Map<String, Object> event) {
        this.timestamp = timestamp;
        this.event = event;
    }

    public MapBasedRow(long timestamp, Map<String, Object> event) {
        this(new DateTime(timestamp), event);
    }

    @Override
    public long getTimestampFromEpoch() {
        return this.timestamp.getMillis();
    }

    @Override
    @JsonProperty
    public DateTime getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty
    public Map<String, Object> getEvent() {
        return this.event;
    }

    @Override
    public List<String> getDimension(String dimension) {
        Object dimValue = this.event.get(dimension);
        if (dimValue == null) {
            return Collections.emptyList();
        }
        if (dimValue instanceof List) {
            return Lists.transform((List)dimValue, TO_STRING_INCLUDING_NULL);
        }
        return Collections.singletonList(String.valueOf(dimValue));
    }

    @Override
    @Nullable
    public Object getRaw(String dimension) {
        return this.event.get(dimension);
    }

    @Override
    @Nullable
    public Float getFloatMetric(String metric) {
        Object metricValue = this.event.get(metric);
        if (metricValue == null) {
            return null;
        }
        if (metricValue instanceof Float) {
            return (Float)metricValue;
        }
        if (metricValue instanceof Number) {
            return Float.valueOf(((Number)metricValue).floatValue());
        }
        if (metricValue instanceof String) {
            try {
                return Float.valueOf(((String)metricValue).replace(",", ""));
            }
            catch (Exception e) {
                throw new ParseException(e, "Unable to parse metrics[%s], value[%s]", metric, metricValue);
            }
        }
        throw new ParseException("Unknown type[%s]", metricValue.getClass());
    }

    @Override
    @Nullable
    public Long getLongMetric(String metric) {
        Object metricValue = this.event.get(metric);
        if (metricValue == null) {
            return null;
        }
        if (metricValue instanceof Long) {
            return (Long)metricValue;
        }
        if (metricValue instanceof Number) {
            return ((Number)metricValue).longValue();
        }
        if (metricValue instanceof String) {
            try {
                String s = ((String)metricValue).replace(",", "");
                return LONG_PAT.matcher(s).matches() ? Long.valueOf(s).longValue() : Double.valueOf(s).longValue();
            }
            catch (Exception e) {
                throw new ParseException(e, "Unable to parse metrics[%s], value[%s]", metric, metricValue);
            }
        }
        throw new ParseException("Unknown type[%s]", metricValue.getClass());
    }

    @Override
    @Nullable
    public Double getDoubleMetric(String metric) {
        Object metricValue = this.event.get(metric);
        if (metricValue == null) {
            return null;
        }
        if (metricValue instanceof Double) {
            return (Double)metricValue;
        }
        if (metricValue instanceof Number) {
            return ((Number)metricValue).doubleValue();
        }
        if (metricValue instanceof String) {
            try {
                return Double.valueOf(((String)metricValue).replace(",", ""));
            }
            catch (Exception e) {
                throw new ParseException(e, "Unable to parse metrics[%s], value[%s]", metric, metricValue);
            }
        }
        throw new ParseException("Unknown type[%s]", metricValue.getClass());
    }

    public String toString() {
        return "MapBasedRow{timestamp=" + this.timestamp + ", event=" + this.event + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapBasedRow that = (MapBasedRow)o;
        if (!this.event.equals(that.event)) {
            return false;
        }
        return this.timestamp.equals((Object)that.timestamp);
    }

    public int hashCode() {
        int result = this.timestamp.hashCode();
        result = 31 * result + this.event.hashCode();
        return result;
    }

    @Override
    public int compareTo(Row o) {
        return this.timestamp.compareTo((ReadableInstant)o.getTimestamp());
    }
}

