/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.collections.bitmap;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.io.druid.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.org.roaringbitmap.IntIterator;
import org.apache.hive.druid.org.roaringbitmap.buffer.ImmutableRoaringBitmap;

public class WrappedImmutableRoaringBitmap
implements ImmutableBitmap {
    private final ImmutableRoaringBitmap bitmap;

    protected WrappedImmutableRoaringBitmap(ByteBuffer byteBuffer) {
        this.bitmap = new ImmutableRoaringBitmap(byteBuffer);
    }

    public WrappedImmutableRoaringBitmap(ImmutableRoaringBitmap immutableRoaringBitmap) {
        this.bitmap = immutableRoaringBitmap;
    }

    public ImmutableRoaringBitmap getBitmap() {
        return this.bitmap;
    }

    @Override
    public byte[] toBytes() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.bitmap.serialize(new DataOutputStream(out));
            return out.toByteArray();
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    @Override
    public int compareTo(ImmutableBitmap other) {
        return 0;
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.bitmap.toString();
    }

    @Override
    public IntIterator iterator() {
        return this.bitmap.getIntIterator();
    }

    @Override
    public int size() {
        return this.bitmap.getCardinality();
    }

    @Override
    public boolean isEmpty() {
        return this.bitmap.isEmpty();
    }

    @Override
    public ImmutableBitmap union(ImmutableBitmap otherBitmap) {
        WrappedImmutableRoaringBitmap other = (WrappedImmutableRoaringBitmap)otherBitmap;
        ImmutableRoaringBitmap unwrappedOtherBitmap = other.bitmap;
        return new WrappedImmutableRoaringBitmap(ImmutableRoaringBitmap.or(this.bitmap, unwrappedOtherBitmap));
    }

    @Override
    public boolean get(int value) {
        return this.bitmap.contains(value);
    }

    @Override
    public ImmutableBitmap intersection(ImmutableBitmap otherBitmap) {
        WrappedImmutableRoaringBitmap other = (WrappedImmutableRoaringBitmap)otherBitmap;
        ImmutableRoaringBitmap unwrappedOtherBitmap = other.bitmap;
        return new WrappedImmutableRoaringBitmap(ImmutableRoaringBitmap.and(this.bitmap, unwrappedOtherBitmap));
    }

    @Override
    public ImmutableBitmap difference(ImmutableBitmap otherBitmap) {
        WrappedImmutableRoaringBitmap other = (WrappedImmutableRoaringBitmap)otherBitmap;
        ImmutableRoaringBitmap unwrappedOtherBitmap = other.bitmap;
        return new WrappedImmutableRoaringBitmap(ImmutableRoaringBitmap.andNot(this.bitmap, unwrappedOtherBitmap));
    }
}

