/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.collections.bitmap;

import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.NoSuchElementException;
import org.apache.hive.druid.io.druid.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.io.druid.collections.bitmap.WrappedBitSetBitmap;
import org.apache.hive.druid.org.roaringbitmap.IntIterator;

public class WrappedImmutableBitSetBitmap
implements ImmutableBitmap {
    protected final BitSet bitmap;

    public WrappedImmutableBitSetBitmap(BitSet bitmap) {
        this.bitmap = bitmap;
    }

    public WrappedImmutableBitSetBitmap() {
        this(new BitSet());
    }

    public WrappedImmutableBitSetBitmap(ByteBuffer byteBuffer) {
        this(BitSet.valueOf(byteBuffer));
    }

    @Override
    public IntIterator iterator() {
        return new BitSetIterator();
    }

    @Override
    public boolean get(int value) {
        return this.bitmap.get(value);
    }

    @Override
    public int size() {
        return this.bitmap.cardinality();
    }

    @Override
    public byte[] toBytes() {
        return this.bitmap.toByteArray();
    }

    @Override
    public int compareTo(ImmutableBitmap other) {
        BitSet otherSet = ((WrappedImmutableBitSetBitmap)other).bitmap;
        int lengthCompare = Integer.compare(otherSet.length(), this.bitmap.length());
        if (lengthCompare != 0) {
            return lengthCompare;
        }
        return Integer.compare(otherSet.nextSetBit(0), this.bitmap.nextSetBit(0));
    }

    @Override
    public boolean isEmpty() {
        return this.bitmap.isEmpty();
    }

    @Override
    public ImmutableBitmap union(ImmutableBitmap otherBitmap) {
        WrappedBitSetBitmap retval = new WrappedBitSetBitmap((BitSet)this.bitmap.clone());
        retval.or((WrappedBitSetBitmap)otherBitmap);
        return retval;
    }

    @Override
    public ImmutableBitmap intersection(ImmutableBitmap otherBitmap) {
        WrappedBitSetBitmap retval = new WrappedBitSetBitmap((BitSet)this.bitmap.clone());
        retval.and((WrappedBitSetBitmap)otherBitmap);
        return retval;
    }

    @Override
    public ImmutableBitmap difference(ImmutableBitmap otherBitmap) {
        WrappedBitSetBitmap retval = new WrappedBitSetBitmap((BitSet)this.bitmap.clone());
        retval.andNot((WrappedBitSetBitmap)otherBitmap);
        return retval;
    }

    private class BitSetIterator
    implements IntIterator {
        private int nextPos;

        BitSetIterator() {
            this.nextPos = WrappedImmutableBitSetBitmap.this.bitmap.nextSetBit(0);
        }

        @Override
        public boolean hasNext() {
            return this.nextPos >= 0;
        }

        @Override
        public int next() {
            int pos = this.nextPos;
            if (pos < 0) {
                throw new NoSuchElementException();
            }
            this.nextPos = WrappedImmutableBitSetBitmap.this.bitmap.nextSetBit(pos + 1);
            return pos;
        }

        @Override
        public IntIterator clone() {
            BitSetIterator newIt = new BitSetIterator();
            newIt.nextPos = this.nextPos;
            return newIt;
        }
    }
}

