/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.collections;

import java.lang.ref.WeakReference;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.io.druid.collections.NonBlockingPool;
import org.apache.hive.druid.io.druid.collections.ResourceHolder;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import sun.misc.Cleaner;

public class StupidPool<T>
implements NonBlockingPool<T> {
    private static final Logger log = new Logger(StupidPool.class);
    private final String name;
    private final Supplier<T> generator;
    private final Queue<ObjectResourceHolder> objects = new ConcurrentLinkedQueue<ObjectResourceHolder>();
    private final AtomicLong poolSize = new AtomicLong(0L);
    private final AtomicLong leakedObjectsCounter = new AtomicLong(0L);
    private final int objectsCacheMaxCount;

    public StupidPool(String name, Supplier<T> generator) {
        this(name, generator, 0, Integer.MAX_VALUE);
    }

    public StupidPool(String name, Supplier<T> generator, int initCount, int objectsCacheMaxCount) {
        Preconditions.checkArgument(initCount <= objectsCacheMaxCount, "initCount[%s] must be less/equal to objectsCacheMaxCount[%s]", initCount, objectsCacheMaxCount);
        this.name = name;
        this.generator = generator;
        this.objectsCacheMaxCount = objectsCacheMaxCount;
        for (int i = 0; i < initCount; ++i) {
            this.objects.add(this.makeObjectWithHandler());
            this.poolSize.incrementAndGet();
        }
    }

    public String toString() {
        return "StupidPool{name=" + this.name + ", objectsCacheMaxCount=" + this.objectsCacheMaxCount + ", poolSize=" + this.poolSize() + "}";
    }

    @Override
    public ResourceHolder<T> take() {
        ObjectResourceHolder resourceHolder = this.objects.poll();
        if (resourceHolder == null) {
            return this.makeObjectWithHandler();
        }
        this.poolSize.decrementAndGet();
        return resourceHolder;
    }

    private ObjectResourceHolder makeObjectWithHandler() {
        T object = this.generator.get();
        ObjectId objectId = new ObjectId();
        ObjectLeakNotifier notifier = new ObjectLeakNotifier(this);
        return new ObjectResourceHolder(object, objectId, Cleaner.create((Object)objectId, (Runnable)notifier), notifier);
    }

    @VisibleForTesting
    long poolSize() {
        return this.poolSize.get();
    }

    @VisibleForTesting
    long leakedObjectsCount() {
        return this.leakedObjectsCounter.get();
    }

    private void tryReturnToPool(T object, ObjectId objectId, Cleaner cleaner, ObjectLeakNotifier notifier) {
        long currentPoolSize;
        do {
            if ((currentPoolSize = this.poolSize.get()) < (long)this.objectsCacheMaxCount) continue;
            notifier.disable();
            cleaner.clean();
            log.debug("cache num entries is exceeding in [%s], objectId [%s]", this, objectId);
            return;
        } while (!this.poolSize.compareAndSet(currentPoolSize, currentPoolSize + 1L));
        if (!this.objects.offer(new ObjectResourceHolder(object, objectId, cleaner, notifier))) {
            this.impossibleOffsetFailed(object, objectId, cleaner, notifier);
        }
    }

    private void impossibleOffsetFailed(T object, ObjectId objectId, Cleaner cleaner, ObjectLeakNotifier notifier) {
        this.poolSize.decrementAndGet();
        notifier.disable();
        cleaner.clean();
        log.error(new ISE("Queue offer failed", new Object[0]), "Could not offer object [%s] back into the queue in [%s], objectId [%s]", object, objectId);
    }

    private static class ObjectId {
        private ObjectId() {
        }
    }

    private static class ObjectLeakNotifier
    implements Runnable {
        final WeakReference<StupidPool<?>> poolReference;
        final AtomicLong leakedObjectsCounter;
        final AtomicBoolean disabled = new AtomicBoolean(false);

        ObjectLeakNotifier(StupidPool<?> pool) {
            this.poolReference = new WeakReference(pool);
            this.leakedObjectsCounter = ((StupidPool)pool).leakedObjectsCounter;
        }

        @Override
        public void run() {
            try {
                if (!this.disabled.getAndSet(true)) {
                    this.leakedObjectsCounter.incrementAndGet();
                    log.warn("Not closed! Object leaked from %s. Allowing gc to prevent leak.", this.poolReference.get());
                }
            }
            catch (Exception e) {
                try {
                    log.error(e, "Exception in ObjectLeakNotifier.run()", new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void disable() {
            this.disabled.set(true);
        }
    }

    private class ObjectResourceHolder
    implements ResourceHolder<T> {
        private final AtomicReference<T> objectRef;
        private ObjectId objectId;
        private Cleaner cleaner;
        private ObjectLeakNotifier notifier;

        ObjectResourceHolder(T object, ObjectId objectId, Cleaner cleaner, ObjectLeakNotifier notifier) {
            this.objectRef = new AtomicReference(object);
            this.objectId = objectId;
            this.cleaner = cleaner;
            this.notifier = notifier;
        }

        @Override
        public T get() {
            Object object = this.objectRef.get();
            if (object == null) {
                throw new ISE("Already Closed!", new Object[0]);
            }
            return object;
        }

        @Override
        public void close() {
            Object object = this.objectRef.get();
            if (object != null && this.objectRef.compareAndSet(object, null)) {
                try {
                    StupidPool.this.tryReturnToPool(object, this.objectId, this.cleaner, this.notifier);
                }
                finally {
                    this.objectId = null;
                    this.cleaner = null;
                    this.notifier = null;
                }
            }
        }
    }
}

