/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.client.selector;

import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.hive.druid.io.druid.client.selector.DiscoverySelector;
import org.apache.hive.druid.io.druid.client.selector.QueryableDruidServer;
import org.apache.hive.druid.io.druid.client.selector.TierSelectorStrategy;
import org.apache.hive.druid.io.druid.server.coordination.DruidServerMetadata;
import org.apache.hive.druid.io.druid.timeline.DataSegment;

public class ServerSelector
implements DiscoverySelector<QueryableDruidServer> {
    private final Int2ObjectRBTreeMap<Set<QueryableDruidServer>> servers;
    private final TierSelectorStrategy strategy;
    private final AtomicReference<DataSegment> segment;

    public ServerSelector(DataSegment segment, TierSelectorStrategy strategy) {
        this.segment = new AtomicReference<DataSegment>(segment);
        this.strategy = strategy;
        this.servers = new Int2ObjectRBTreeMap(strategy.getComparator());
    }

    public DataSegment getSegment() {
        return this.segment.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServerAndUpdateSegment(QueryableDruidServer server, DataSegment segment) {
        ServerSelector serverSelector = this;
        synchronized (serverSelector) {
            this.segment.set(segment);
            int priority = server.getServer().getPriority();
            Set priorityServers = this.servers.computeIfAbsent(priority, p -> new HashSet());
            priorityServers.add(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeServer(QueryableDruidServer server) {
        ServerSelector serverSelector = this;
        synchronized (serverSelector) {
            int priority = server.getServer().getPriority();
            Set<QueryableDruidServer> priorityServers = this.servers.get(priority);
            if (priorityServers == null) {
                return false;
            }
            boolean result = priorityServers.remove(server);
            if (priorityServers.isEmpty()) {
                this.servers.remove(priority);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        ServerSelector serverSelector = this;
        synchronized (serverSelector) {
            return this.servers.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DruidServerMetadata> getCandidates(int numCandidates) {
        ServerSelector serverSelector = this;
        synchronized (serverSelector) {
            if (numCandidates > 0) {
                return this.strategy.pick(this.servers, this.segment.get(), numCandidates).stream().map(server -> server.getServer().getMetadata()).collect(Collectors.toList());
            }
            return this.servers.values().stream().flatMap(Collection::stream).map(server -> server.getServer().getMetadata()).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryableDruidServer pick() {
        ServerSelector serverSelector = this;
        synchronized (serverSelector) {
            return this.strategy.pick(this.servers, this.segment.get());
        }
    }
}

