/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.client.selector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Iterators;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.client.selector.QueryableDruidServer;
import org.apache.hive.druid.io.druid.client.selector.ServerSelectorStrategy;
import org.apache.hive.druid.io.druid.timeline.DataSegment;

public class RandomServerSelectorStrategy
implements ServerSelectorStrategy {
    @Override
    public QueryableDruidServer pick(Set<QueryableDruidServer> servers, DataSegment segment) {
        return Iterators.get(servers.iterator(), ThreadLocalRandom.current().nextInt(servers.size()));
    }

    @Override
    public List<QueryableDruidServer> pick(Set<QueryableDruidServer> servers, DataSegment segment, int numServersToPick) {
        if (servers.size() <= numServersToPick) {
            return ImmutableList.copyOf(servers);
        }
        ArrayList<QueryableDruidServer> list = Lists.newArrayList(servers);
        Collections.shuffle(list, ThreadLocalRandom.current());
        return ImmutableList.copyOf(list.subList(0, numServersToPick));
    }
}

