/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.client.selector;

import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.io.druid.client.selector.QueryableDruidServer;
import org.apache.hive.druid.io.druid.client.selector.ServerSelectorStrategy;
import org.apache.hive.druid.io.druid.client.selector.TierSelectorStrategy;
import org.apache.hive.druid.io.druid.timeline.DataSegment;

public abstract class AbstractTierSelectorStrategy
implements TierSelectorStrategy {
    private final ServerSelectorStrategy serverSelectorStrategy;

    public AbstractTierSelectorStrategy(ServerSelectorStrategy serverSelectorStrategy) {
        this.serverSelectorStrategy = serverSelectorStrategy;
    }

    @Override
    public QueryableDruidServer pick(Int2ObjectRBTreeMap<Set<QueryableDruidServer>> prioritizedServers, DataSegment segment) {
        return Iterables.getOnlyElement(this.pick(prioritizedServers, segment, 1), null);
    }

    @Override
    public List<QueryableDruidServer> pick(Int2ObjectRBTreeMap<Set<QueryableDruidServer>> prioritizedServers, DataSegment segment, int numServersToPick) {
        ArrayList<QueryableDruidServer> result = new ArrayList<QueryableDruidServer>(numServersToPick);
        for (Set priorityServers : prioritizedServers.values()) {
            result.addAll(this.serverSelectorStrategy.pick(priorityServers, segment, numServersToPick - result.size()));
            if (result.size() != numServersToPick) continue;
            break;
        }
        return result;
    }
}

