/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.client.TimelineServerView;
import org.apache.hive.druid.io.druid.client.selector.ServerSelector;
import org.apache.hive.druid.io.druid.query.DataSource;
import org.apache.hive.druid.io.druid.query.LocatedSegmentDescriptor;
import org.apache.hive.druid.io.druid.query.SegmentDescriptor;
import org.apache.hive.druid.io.druid.query.TableDataSource;
import org.apache.hive.druid.io.druid.server.coordination.DruidServerMetadata;
import org.apache.hive.druid.io.druid.timeline.TimelineLookup;
import org.apache.hive.druid.io.druid.timeline.TimelineObjectHolder;
import org.apache.hive.druid.io.druid.timeline.partition.PartitionChunk;
import org.joda.time.Interval;

public class ServerViewUtil {
    public static List<LocatedSegmentDescriptor> getTargetLocations(TimelineServerView serverView, String datasource, List<Interval> intervals, int numCandidates) {
        return ServerViewUtil.getTargetLocations(serverView, new TableDataSource(datasource), intervals, numCandidates);
    }

    public static List<LocatedSegmentDescriptor> getTargetLocations(TimelineServerView serverView, DataSource datasource, List<Interval> intervals, int numCandidates) {
        TimelineLookup<String, ServerSelector> timeline = serverView.getTimeline(datasource);
        if (timeline == null) {
            return Collections.emptyList();
        }
        ArrayList<LocatedSegmentDescriptor> located = Lists.newArrayList();
        for (Interval interval : intervals) {
            for (TimelineObjectHolder<String, ServerSelector> holder : timeline.lookup(interval)) {
                for (PartitionChunk<ServerSelector> partitionChunk : holder.getObject()) {
                    ServerSelector selector = partitionChunk.getObject();
                    SegmentDescriptor descriptor = new SegmentDescriptor(holder.getInterval(), holder.getVersion(), partitionChunk.getChunkNumber());
                    long size = selector.getSegment().getSize();
                    List<DruidServerMetadata> candidates = selector.getCandidates(numCandidates);
                    located.add(new LocatedSegmentDescriptor(descriptor, size, candidates));
                }
            }
        }
        return located;
    }
}

