/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.emitter.service;

import java.io.IOException;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.metamx.common.lifecycle.LifecycleStart;
import org.apache.hive.druid.com.metamx.common.lifecycle.LifecycleStop;
import org.apache.hive.druid.com.metamx.emitter.core.Emitter;
import org.apache.hive.druid.com.metamx.emitter.core.Event;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceEventBuilder;

public class ServiceEmitter
implements Emitter {
    private final ImmutableMap<String, String> serviceDimensions;
    private final Emitter emitter;

    public ServiceEmitter(String service, String host, Emitter emitter) {
        this(service, host, emitter, ImmutableMap.of());
    }

    public ServiceEmitter(String service, String host, Emitter emitter, ImmutableMap<String, String> otherServiceDimensions) {
        this.serviceDimensions = ImmutableMap.builder().put("service", Preconditions.checkNotNull(service)).put("host", Preconditions.checkNotNull(host)).putAll(otherServiceDimensions).build();
        this.emitter = emitter;
    }

    public String getService() {
        return this.serviceDimensions.get("service");
    }

    public String getHost() {
        return this.serviceDimensions.get("host");
    }

    @Override
    @LifecycleStart
    public void start() {
        this.emitter.start();
    }

    @Override
    public void emit(Event event) {
        this.emitter.emit(event);
    }

    public void emit(ServiceEventBuilder builder) {
        this.emit((Event)builder.build(this.serviceDimensions));
    }

    @Override
    public void flush() throws IOException {
        this.emitter.flush();
    }

    @Override
    @LifecycleStop
    public void close() throws IOException {
        this.emitter.close();
    }
}

