/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.emitter.core;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.metamx.common.lifecycle.Lifecycle;
import org.apache.hive.druid.com.metamx.common.lifecycle.LifecycleStart;
import org.apache.hive.druid.com.metamx.common.lifecycle.LifecycleStop;
import org.apache.hive.druid.com.metamx.emitter.core.Emitter;
import org.apache.hive.druid.com.metamx.emitter.core.Event;
import org.apache.hive.druid.com.metamx.emitter.core.HttpPostEmitter;
import org.apache.hive.druid.com.metamx.emitter.core.ParametrizedUriEmitterConfig;
import org.apache.hive.druid.com.metamx.emitter.core.UriExtractor;
import org.apache.hive.druid.com.metamx.http.client.HttpClient;

public class ParametrizedUriEmitter
implements Flushable,
Closeable,
Emitter {
    private final Map<URI, HttpPostEmitter> emitters = new HashMap<URI, HttpPostEmitter>();
    private final UriExtractor uriExtractor;
    private final Lifecycle innerLifecycle = new Lifecycle();
    private final HttpClient client;
    private final ObjectMapper jsonMapper;
    private final ParametrizedUriEmitterConfig config;

    public ParametrizedUriEmitter(ParametrizedUriEmitterConfig config, HttpClient client, ObjectMapper jsonMapper, UriExtractor uriExtractor) {
        this.config = config;
        this.client = client;
        this.jsonMapper = jsonMapper;
        this.uriExtractor = uriExtractor;
    }

    @Override
    @LifecycleStart
    public void start() {
        try {
            this.innerLifecycle.start();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void emit(Event event) {
        try {
            URI uri = this.uriExtractor.apply(event);
            HttpPostEmitter emitter = this.emitters.get(uri);
            if (emitter == null) {
                Map<URI, HttpPostEmitter> map = this.emitters;
                synchronized (map) {
                    emitter = this.emitters.get(uri);
                    if (emitter == null) {
                        emitter = new HttpPostEmitter(this.config.buildHttpEmitterConfig(uri.toString()), this.client, this.jsonMapper);
                        this.innerLifecycle.addMaybeStartManagedInstance(emitter);
                        this.emitters.put(uri, emitter);
                    }
                }
            }
            emitter.emit(event);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(String.format("Failed to extract URI for event: %s", event.toMap().toString()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @LifecycleStop
    public void close() throws IOException {
        this.innerLifecycle.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Map<URI, HttpPostEmitter> map = this.emitters;
        synchronized (map) {
            for (Emitter emitter : this.emitters.values()) {
                emitter.flush();
            }
        }
    }
}

