/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.common.parsers;

import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JsonNode;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Charsets;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.com.metamx.common.parsers.ParseException;
import org.apache.hive.druid.com.metamx.common.parsers.Parser;
import org.apache.hive.druid.com.metamx.common.parsers.ParserUtils;

public class JSONParser
implements Parser<String, Object> {
    public static final Function<JsonNode, Object> valueFunction = new Function<JsonNode, Object>(){

        @Override
        public Object apply(JsonNode node) {
            if (node == null || node.isMissingNode() || node.isNull()) {
                return null;
            }
            if (node.isIntegralNumber()) {
                if (node.canConvertToLong()) {
                    return node.asLong();
                }
                return node.asDouble();
            }
            if (node.isFloatingPointNumber()) {
                return node.asDouble();
            }
            String s = node.asText();
            CharsetEncoder enc = Charsets.UTF_8.newEncoder();
            if (s != null && !enc.canEncode(s)) {
                return new String(s.getBytes(Charsets.UTF_8), Charsets.UTF_8);
            }
            return s;
        }
    };
    private final ObjectMapper objectMapper;
    private ArrayList<String> fieldNames;
    private final Set<String> exclude;

    public JSONParser() {
        this(new ObjectMapper(), null, null);
    }

    @Deprecated
    public JSONParser(Iterable<String> fieldNames) {
        this(new ObjectMapper(), fieldNames, null);
    }

    public JSONParser(ObjectMapper objectMapper, Iterable<String> fieldNames) {
        this(objectMapper, fieldNames, null);
    }

    public JSONParser(ObjectMapper objectMapper, Iterable<String> fieldNames, Iterable<String> exclude) {
        this.objectMapper = objectMapper;
        if (fieldNames != null) {
            this.setFieldNames(fieldNames);
        }
        this.exclude = exclude != null ? Sets.newHashSet(exclude) : Sets.newHashSet();
    }

    @Override
    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    @Override
    public void setFieldNames(Iterable<String> fieldNames) {
        ParserUtils.validateFields(fieldNames);
        this.fieldNames = Lists.newArrayList(fieldNames);
    }

    @Override
    public Map<String, Object> parse(String input) {
        try {
            Iterator<String> keysIter;
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            JsonNode root = this.objectMapper.readTree(input);
            Iterator<String> iterator = keysIter = this.fieldNames == null ? root.fieldNames() : this.fieldNames.iterator();
            while (keysIter.hasNext()) {
                Object nodeValue;
                String key = keysIter.next();
                if (this.exclude.contains(key)) continue;
                JsonNode node = root.path(key);
                if (node.isArray()) {
                    nodeValue = Lists.newArrayListWithExpectedSize(node.size());
                    for (JsonNode subnode : node) {
                        Object subnodeValue = valueFunction.apply(subnode);
                        if (subnodeValue == null) continue;
                        nodeValue.add(subnodeValue);
                    }
                    map.put(key, nodeValue);
                    continue;
                }
                nodeValue = valueFunction.apply(node);
                if (nodeValue == null) continue;
                map.put(key, nodeValue);
            }
            return map;
        }
        catch (Exception e) {
            throw new ParseException(e, "Unable to parse row [%s]", input);
        }
    }
}

