/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.common.io.smoosh;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hive.druid.com.google.common.base.Charsets;
import org.apache.hive.druid.com.google.common.base.Joiner;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.io.ByteStreams;
import org.apache.hive.druid.com.google.common.io.Closeables;
import org.apache.hive.druid.com.google.common.io.Files;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.com.metamx.common.IAE;
import org.apache.hive.druid.com.metamx.common.ISE;
import org.apache.hive.druid.com.metamx.common.io.smoosh.Metadata;
import org.apache.hive.druid.com.metamx.common.io.smoosh.SmooshedWriter;

public class FileSmoosher
implements Closeable {
    private static final String FILE_EXTENSION = "smoosh";
    private static final Joiner joiner = Joiner.on(",");
    private final File baseDir;
    private final int maxChunkSize;
    private final List<File> outFiles = Lists.newArrayList();
    private final Map<String, Metadata> internalFiles = Maps.newTreeMap();
    private Outer currOut = null;

    public FileSmoosher(File baseDir) {
        this(baseDir, Integer.MAX_VALUE);
    }

    public FileSmoosher(File baseDir, int maxChunkSize) {
        this.baseDir = baseDir;
        this.maxChunkSize = maxChunkSize;
        Preconditions.checkArgument(maxChunkSize > 0, "maxChunkSize must be a positive value.");
    }

    private FileSmoosher(File baseDir, int maxChunkSize, List<File> outFiles, Map<String, Metadata> internalFiles) {
        this.baseDir = baseDir;
        this.maxChunkSize = maxChunkSize;
        this.outFiles.addAll(outFiles);
        this.internalFiles.putAll(internalFiles);
    }

    public Set<String> getInternalFilenames() {
        return this.internalFiles.keySet();
    }

    public void add(File fileToAdd) throws IOException {
        this.add(fileToAdd.getName(), Files.map(fileToAdd));
    }

    public void add(String name, File fileToAdd) throws IOException {
        this.add(name, Files.map(fileToAdd));
    }

    public void add(String name, ByteBuffer bufferToAdd) throws IOException {
        this.add(name, Arrays.asList(bufferToAdd));
    }

    public void add(String name, List<ByteBuffer> bufferToAdd) throws IOException {
        if (name.contains(",")) {
            throw new IAE("Cannot have a comma in the name of a file, got[%s].", name);
        }
        if (this.internalFiles.get(name) != null) {
            throw new IAE("Cannot add files of the same name, already have [%s]", name);
        }
        long size = 0L;
        for (ByteBuffer buffer : bufferToAdd) {
            size += (long)buffer.remaining();
        }
        try (SmooshedWriter out = this.addWithSmooshedWriter(name, size);){
            for (ByteBuffer buffer : bufferToAdd) {
                out.write(buffer);
            }
        }
    }

    public SmooshedWriter addWithSmooshedWriter(final String name, final long size) throws IOException {
        if (size > (long)this.maxChunkSize) {
            throw new IAE("Asked to add buffers[%,d] larger than configured max[%,d]", size, this.maxChunkSize);
        }
        if (this.currOut == null) {
            this.currOut = this.getNewCurrOut();
        }
        if ((long)this.currOut.bytesLeft() < size) {
            Closeables.close(this.currOut, false);
            this.currOut = this.getNewCurrOut();
        }
        final int startOffset = this.currOut.getCurrOffset();
        return new SmooshedWriter(){
            private boolean open = true;
            private long bytesWritten = 0L;

            @Override
            public int write(InputStream in) throws IOException {
                return this.verifySize(FileSmoosher.this.currOut.write(in));
            }

            @Override
            public int write(ByteBuffer in) throws IOException {
                return this.verifySize(FileSmoosher.this.currOut.write(in));
            }

            private int verifySize(int bytesWrittenInChunk) throws IOException {
                this.bytesWritten += (long)bytesWrittenInChunk;
                if (this.bytesWritten != (long)(FileSmoosher.this.currOut.getCurrOffset() - startOffset)) {
                    throw new ISE("WTF? Perhaps there is some concurrent modification going on?", new Object[0]);
                }
                if (this.bytesWritten > size) {
                    throw new ISE("Wrote[%,d] bytes for something of size[%,d].  Liar!!!", this.bytesWritten, size);
                }
                return bytesWrittenInChunk;
            }

            @Override
            public boolean isOpen() {
                return this.open;
            }

            @Override
            public void close() throws IOException {
                this.open = false;
                FileSmoosher.this.internalFiles.put(name, new Metadata(FileSmoosher.this.currOut.getFileNum(), startOffset, FileSmoosher.this.currOut.getCurrOffset()));
                if (this.bytesWritten != (long)(FileSmoosher.this.currOut.getCurrOffset() - startOffset)) {
                    throw new ISE("WTF? Perhaps there is some concurrent modification going on?", new Object[0]);
                }
                if (this.bytesWritten != size) {
                    throw new IOException(String.format("Expected [%,d] bytes, only saw [%,d], potential corruption?", size, this.bytesWritten));
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Closeables.close(this.currOut, false);
        File metaFile = FileSmoosher.metaFile(this.baseDir);
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(metaFile), Charsets.UTF_8));
            out.write(String.format("v1,%d,%d", this.maxChunkSize, this.outFiles.size()));
            out.write("\n");
            for (Map.Entry<String, Metadata> entry : this.internalFiles.entrySet()) {
                Metadata metadata = entry.getValue();
                out.write(joiner.join(entry.getKey(), metadata.getFileNum(), metadata.getStartOffset(), metadata.getEndOffset()));
                out.write("\n");
            }
        }
        catch (Throwable throwable) {
            Closeables.close(out, false);
            throw throwable;
        }
        Closeables.close(out, false);
    }

    private Outer getNewCurrOut() throws FileNotFoundException {
        int fileNum = this.outFiles.size();
        File outFile = FileSmoosher.makeChunkFile(this.baseDir, fileNum);
        this.outFiles.add(outFile);
        return new Outer(fileNum, new BufferedOutputStream(new FileOutputStream(outFile)), this.maxChunkSize);
    }

    static File metaFile(File baseDir) {
        return new File(baseDir, String.format("meta.%s", FILE_EXTENSION));
    }

    static File makeChunkFile(File baseDir, int i) {
        return new File(baseDir, String.format("%05d.%s", i, FILE_EXTENSION));
    }

    public static class Outer
    implements SmooshedWriter {
        private final int fileNum;
        private final OutputStream out;
        private final int maxLength;
        private boolean open = true;
        private int currOffset = 0;

        Outer(int fileNum, OutputStream out, int maxLength) {
            this.fileNum = fileNum;
            this.out = out;
            this.maxLength = maxLength;
        }

        public int getFileNum() {
            return this.fileNum;
        }

        public int getCurrOffset() {
            return this.currOffset;
        }

        public int bytesLeft() {
            return this.maxLength - this.currOffset;
        }

        @Override
        public int write(ByteBuffer buffer) throws IOException {
            WritableByteChannel channel = Channels.newChannel(this.out);
            return this.addToOffset(channel.write(buffer));
        }

        @Override
        public int write(InputStream in) throws IOException {
            return this.addToOffset(Ints.checkedCast(ByteStreams.copy(in, this.out)));
        }

        public int addToOffset(int numBytesWritten) {
            if (numBytesWritten > this.bytesLeft()) {
                throw new ISE("Wrote more bytes[%,d] than available[%,d]. Don't do that.", numBytesWritten, this.bytesLeft());
            }
            this.currOffset += numBytesWritten;
            return numBytesWritten;
        }

        @Override
        public boolean isOpen() {
            return this.open;
        }

        @Override
        public void close() throws IOException {
            this.open = false;
            this.out.close();
        }
    }
}

