/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.fasterxml.jackson.databind.deser.std;

import java.io.IOException;
import java.util.EnumMap;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonParser;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonToken;
import org.apache.hive.druid.com.fasterxml.jackson.databind.BeanProperty;
import org.apache.hive.druid.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.hive.druid.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JavaType;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.hive.druid.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import org.apache.hive.druid.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.hive.druid.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;

public class EnumMapDeserializer
extends StdDeserializer<EnumMap<?, ?>>
implements ContextualDeserializer {
    private static final long serialVersionUID = 4564890642370311174L;
    protected final JavaType _mapType;
    protected final Class<?> _enumClass;
    protected JsonDeserializer<Enum<?>> _keyDeserializer;
    protected JsonDeserializer<Object> _valueDeserializer;
    protected final TypeDeserializer _valueTypeDeserializer;

    public EnumMapDeserializer(JavaType mapType, JsonDeserializer<?> keyDeserializer, JsonDeserializer<?> valueDeser, TypeDeserializer valueTypeDeser) {
        super(EnumMap.class);
        this._mapType = mapType;
        this._enumClass = mapType.getKeyType().getRawClass();
        this._keyDeserializer = keyDeserializer;
        this._valueDeserializer = valueDeser;
        this._valueTypeDeserializer = valueTypeDeser;
    }

    public EnumMapDeserializer withResolved(JsonDeserializer<?> keyDeserializer, JsonDeserializer<?> valueDeserializer, TypeDeserializer valueTypeDeser) {
        if (keyDeserializer == this._keyDeserializer && valueDeserializer == this._valueDeserializer && valueTypeDeser == this._valueTypeDeserializer) {
            return this;
        }
        return new EnumMapDeserializer(this._mapType, keyDeserializer, valueDeserializer, this._valueTypeDeserializer);
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JsonDeserializer<Object> vd;
        JsonDeserializer<Object> kd = this._keyDeserializer;
        if (kd == null) {
            kd = ctxt.findContextualValueDeserializer(this._mapType.getKeyType(), property);
        }
        vd = (vd = this._valueDeserializer) == null ? ctxt.findContextualValueDeserializer(this._mapType.getContentType(), property) : ctxt.handleSecondaryContextualization(vd, property);
        TypeDeserializer vtd = this._valueTypeDeserializer;
        if (vtd != null) {
            vtd = vtd.forProperty(property);
        }
        return this.withResolved(kd, vd, vtd);
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public EnumMap<?, ?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (jp.getCurrentToken() != JsonToken.START_OBJECT) {
            throw ctxt.mappingException(EnumMap.class);
        }
        EnumMap<?, ?> result = this.constructMap();
        JsonDeserializer<Object> valueDes = this._valueDeserializer;
        TypeDeserializer typeDeser = this._valueTypeDeserializer;
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            Enum<?> key = this._keyDeserializer.deserialize(jp, ctxt);
            if (key == null) {
                if (!ctxt.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL)) {
                    String value = null;
                    try {
                        if (jp.hasCurrentToken()) {
                            value = jp.getText();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    throw ctxt.weirdStringException(value, this._enumClass, "value not one of declared Enum instance names");
                }
                jp.nextToken();
                jp.skipChildren();
                continue;
            }
            JsonToken t = jp.nextToken();
            Object value = t == JsonToken.VALUE_NULL ? valueDes.getNullValue() : (typeDeser == null ? valueDes.deserialize(jp, ctxt) : valueDes.deserializeWithType(jp, ctxt, typeDeser));
            result.put(key, value);
        }
        return result;
    }

    @Override
    public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        return typeDeserializer.deserializeTypedFromObject(jp, ctxt);
    }

    private EnumMap<?, ?> constructMap() {
        return new EnumMap(this._enumClass);
    }
}

