/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid.serde;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.druid.DruidStorageHandler;
import org.apache.hadoop.hive.druid.DruidStorageHandlerUtils;
import org.apache.hadoop.hive.druid.serde.DruidSerDeUtils;
import org.apache.hadoop.hive.druid.serde.DruidWritable;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeSpec;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.query.Druids;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.PostAggregator;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQuery;
import org.apache.hive.druid.io.druid.query.metadata.metadata.ColumnAnalysis;
import org.apache.hive.druid.io.druid.query.metadata.metadata.SegmentAnalysis;
import org.apache.hive.druid.io.druid.query.metadata.metadata.SegmentMetadataQuery;
import org.apache.hive.druid.io.druid.query.select.SelectQuery;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQuery;
import org.apache.hive.druid.io.druid.query.topn.TopNQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SerDeSpec(schemaProps={"druid.datasource"})
public class DruidSerDe
extends AbstractSerDe {
    protected static final Logger LOG = LoggerFactory.getLogger(DruidSerDe.class);
    private String[] columns;
    private PrimitiveTypeInfo[] types;
    private ObjectInspector inspector;

    public void initialize(Configuration configuration, Properties properties) throws SerDeException {
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<PrimitiveTypeInfo> columnTypes = new ArrayList<PrimitiveTypeInfo>();
        ArrayList<Object> inspectors = new ArrayList<Object>();
        String druidQuery = properties.getProperty("druid.query.json");
        if (druidQuery == null) {
            if (!org.apache.commons.lang3.StringUtils.isEmpty(properties.getProperty("columns")) && !org.apache.commons.lang3.StringUtils.isEmpty(properties.getProperty("columns.types"))) {
                columnNames.addAll(Utilities.getColumnNames((Properties)properties));
                if (!columnNames.contains("__time")) {
                    throw new SerDeException("Timestamp column (' __time') not specified in create table; list of columns is : " + properties.getProperty("columns"));
                }
                columnTypes.addAll(Lists.transform(Utilities.getColumnTypes((Properties)properties), type -> TypeInfoFactory.getPrimitiveTypeInfo((String)type)));
                inspectors.addAll(Lists.transform(columnTypes, type -> PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)type)));
                this.columns = columnNames.toArray(new String[columnNames.size()]);
                this.types = columnTypes.toArray(new PrimitiveTypeInfo[columnTypes.size()]);
                this.inspector = ObjectInspectorFactory.getStandardStructObjectInspector(columnNames, inspectors);
            } else {
                SegmentAnalysis schemaInfo;
                String dataSource = properties.getProperty("druid.datasource");
                if (dataSource == null) {
                    throw new SerDeException("Druid data source not specified; use druid.datasource in table properties");
                }
                Druids.SegmentMetadataQueryBuilder builder = new Druids.SegmentMetadataQueryBuilder();
                builder.dataSource(dataSource);
                builder.merge(true);
                builder.analysisTypes(new SegmentMetadataQuery.AnalysisType[0]);
                SegmentMetadataQuery query = builder.build();
                String address = HiveConf.getVar((Configuration)configuration, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_BROKER_DEFAULT_ADDRESS);
                if (org.apache.commons.lang3.StringUtils.isEmpty(address)) {
                    throw new SerDeException("Druid broker address not specified in configuration");
                }
                try {
                    schemaInfo = this.submitMetadataRequest(address, query);
                }
                catch (IOException e) {
                    throw new SerDeException((Throwable)e);
                }
                for (Map.Entry<String, ColumnAnalysis> columnInfo : schemaInfo.getColumns().entrySet()) {
                    PrimitiveTypeInfo type2;
                    if (columnInfo.getKey().equals("__time")) {
                        columnNames.add(columnInfo.getKey());
                        type2 = TypeInfoFactory.timestampTypeInfo;
                        columnTypes.add(type2);
                        inspectors.add(PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)type2));
                        continue;
                    }
                    columnNames.add(columnInfo.getKey());
                    type2 = DruidSerDeUtils.convertDruidToHiveType(columnInfo.getValue().getType());
                    columnTypes.add(type2);
                    inspectors.add(PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)type2));
                }
                this.columns = columnNames.toArray(new String[columnNames.size()]);
                this.types = columnTypes.toArray(new PrimitiveTypeInfo[columnTypes.size()]);
                this.inspector = ObjectInspectorFactory.getStandardStructObjectInspector(columnNames, inspectors);
            }
        } else {
            try {
                Query query = DruidStorageHandlerUtils.JSON_MAPPER.readValue(druidQuery, Query.class);
                ImmutableMap.Builder mapColumnNamesTypes = ImmutableMap.builder();
                if (!org.apache.commons.lang3.StringUtils.isEmpty(properties.getProperty("columns")) && !org.apache.commons.lang3.StringUtils.isEmpty(properties.getProperty("columns.types"))) {
                    List propColumnNames = Utilities.getColumnNames((Properties)properties);
                    List propColumnTypes = Utilities.getColumnTypes((Properties)properties);
                    for (int i = 0; i < propColumnNames.size(); ++i) {
                        mapColumnNamesTypes.put(propColumnNames.get(i), TypeInfoFactory.getPrimitiveTypeInfo((String)((String)propColumnTypes.get(i))));
                    }
                }
                switch (query.getType()) {
                    case "timeseries": {
                        this.inferSchema((TimeseriesQuery)query, columnNames, columnTypes, mapColumnNamesTypes.build());
                        break;
                    }
                    case "topN": {
                        this.inferSchema((TopNQuery)query, columnNames, columnTypes, mapColumnNamesTypes.build());
                        break;
                    }
                    case "select": {
                        String address = HiveConf.getVar((Configuration)configuration, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_BROKER_DEFAULT_ADDRESS);
                        if (org.apache.commons.lang3.StringUtils.isEmpty(address)) {
                            throw new SerDeException("Druid broker address not specified in configuration");
                        }
                        this.inferSchema((SelectQuery)query, columnNames, columnTypes, address, mapColumnNamesTypes.build());
                        break;
                    }
                    case "groupBy": {
                        this.inferSchema((GroupByQuery)query, columnNames, columnTypes, mapColumnNamesTypes.build());
                        break;
                    }
                    default: {
                        throw new SerDeException("Not supported Druid query");
                    }
                }
            }
            catch (Exception e) {
                throw new SerDeException((Throwable)e);
            }
            this.columns = new String[columnNames.size()];
            this.types = new PrimitiveTypeInfo[columnNames.size()];
            for (int i = 0; i < columnTypes.size(); ++i) {
                this.columns[i] = (String)columnNames.get(i);
                this.types[i] = (PrimitiveTypeInfo)columnTypes.get(i);
                inspectors.add(PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)this.types[i]));
            }
            this.inspector = ObjectInspectorFactory.getStandardStructObjectInspector(columnNames, inspectors);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("DruidSerDe initialized with\n\t columns: " + columnNames + "\n\t types: " + columnTypes);
        }
    }

    protected SegmentAnalysis submitMetadataRequest(String address, SegmentMetadataQuery query) throws SerDeException, IOException {
        List resultsList;
        InputStream response;
        try {
            response = DruidStorageHandlerUtils.submitRequest(DruidStorageHandler.getHttpClient(), DruidStorageHandlerUtils.createSmileRequest(address, query));
        }
        catch (Exception e) {
            throw new SerDeException(StringUtils.stringifyException((Throwable)e));
        }
        try {
            resultsList = (List)DruidStorageHandlerUtils.SMILE_MAPPER.readValue(response, (TypeReference)new TypeReference<List<SegmentAnalysis>>(){});
        }
        catch (Exception e) {
            response.close();
            throw new SerDeException(StringUtils.stringifyException((Throwable)e));
        }
        if (resultsList == null || resultsList.isEmpty()) {
            throw new SerDeException("Connected to Druid but could not retrieve datasource information");
        }
        if (resultsList.size() != 1) {
            throw new SerDeException("Information about segments should have been merged");
        }
        return (SegmentAnalysis)resultsList.get(0);
    }

    private void inferSchema(TimeseriesQuery query, List<String> columnNames, List<PrimitiveTypeInfo> columnTypes, Map<String, PrimitiveTypeInfo> mapColumnNamesTypes) {
        columnNames.add("__time");
        columnTypes.add(TypeInfoFactory.timestampTypeInfo);
        for (AggregatorFactory af : query.getAggregatorSpecs()) {
            columnNames.add(af.getName());
            PrimitiveTypeInfo typeInfo = mapColumnNamesTypes.get(af.getName());
            if (typeInfo != null) {
                columnTypes.add(typeInfo);
                continue;
            }
            columnTypes.add(DruidSerDeUtils.convertDruidToHiveType(af.getTypeName()));
        }
        for (PostAggregator pa : query.getPostAggregatorSpecs()) {
            columnNames.add(pa.getName());
            columnTypes.add(TypeInfoFactory.floatTypeInfo);
        }
    }

    private void inferSchema(TopNQuery query, List<String> columnNames, List<PrimitiveTypeInfo> columnTypes, Map<String, PrimitiveTypeInfo> mapColumnNamesTypes) {
        columnNames.add("__time");
        columnTypes.add(TypeInfoFactory.timestampTypeInfo);
        columnNames.add(query.getDimensionSpec().getOutputName());
        columnTypes.add(TypeInfoFactory.stringTypeInfo);
        for (AggregatorFactory af : query.getAggregatorSpecs()) {
            columnNames.add(af.getName());
            PrimitiveTypeInfo typeInfo = mapColumnNamesTypes.get(af.getName());
            if (typeInfo != null) {
                columnTypes.add(typeInfo);
                continue;
            }
            columnTypes.add(DruidSerDeUtils.convertDruidToHiveType(af.getTypeName()));
        }
        for (PostAggregator pa : query.getPostAggregatorSpecs()) {
            columnNames.add(pa.getName());
            columnTypes.add(TypeInfoFactory.floatTypeInfo);
        }
    }

    private void inferSchema(SelectQuery query, List<String> columnNames, List<PrimitiveTypeInfo> columnTypes, String address, Map<String, PrimitiveTypeInfo> mapColumnNamesTypes) throws SerDeException {
        SegmentAnalysis schemaInfo;
        columnNames.add("__time");
        columnTypes.add(TypeInfoFactory.timestampTypeInfo);
        for (DimensionSpec ds : query.getDimensions()) {
            columnNames.add(ds.getOutputName());
            columnTypes.add(TypeInfoFactory.stringTypeInfo);
        }
        Druids.SegmentMetadataQueryBuilder builder = new Druids.SegmentMetadataQueryBuilder();
        builder.dataSource(query.getDataSource());
        builder.merge(true);
        builder.analysisTypes(new SegmentMetadataQuery.AnalysisType[0]);
        SegmentMetadataQuery metadataQuery = builder.build();
        try {
            schemaInfo = this.submitMetadataRequest(address, metadataQuery);
        }
        catch (IOException e) {
            throw new SerDeException((Throwable)e);
        }
        if (schemaInfo == null) {
            throw new SerDeException("Connected to Druid but could not retrieve datasource information");
        }
        for (String metric : query.getMetrics()) {
            columnNames.add(metric);
            PrimitiveTypeInfo typeInfo = mapColumnNamesTypes.get(metric);
            if (typeInfo != null) {
                columnTypes.add(typeInfo);
                continue;
            }
            columnTypes.add(DruidSerDeUtils.convertDruidToHiveType(schemaInfo.getColumns().get(metric).getType()));
        }
    }

    private void inferSchema(GroupByQuery query, List<String> columnNames, List<PrimitiveTypeInfo> columnTypes, Map<String, PrimitiveTypeInfo> mapColumnNamesTypes) {
        columnNames.add("__time");
        columnTypes.add(TypeInfoFactory.timestampTypeInfo);
        for (DimensionSpec ds : query.getDimensions()) {
            columnNames.add(ds.getOutputName());
            columnTypes.add(DruidSerDeUtils.extractTypeFromDimension(ds));
        }
        for (AggregatorFactory af : query.getAggregatorSpecs()) {
            columnNames.add(af.getName());
            PrimitiveTypeInfo typeInfo = mapColumnNamesTypes.get(af.getName());
            if (typeInfo != null) {
                columnTypes.add(typeInfo);
                continue;
            }
            columnTypes.add(DruidSerDeUtils.convertDruidToHiveType(af.getTypeName()));
        }
        for (PostAggregator pa : query.getPostAggregatorSpecs()) {
            columnNames.add(pa.getName());
            columnTypes.add(TypeInfoFactory.floatTypeInfo);
        }
    }

    public Class<? extends Writable> getSerializedClass() {
        return DruidWritable.class;
    }

    public Writable serialize(Object o, ObjectInspector objectInspector) throws SerDeException {
        if (objectInspector.getCategory() != ObjectInspector.Category.STRUCT) {
            throw new SerDeException(((Object)((Object)this)).getClass().toString() + " can only serialize struct types, but we got: " + objectInspector.getTypeName());
        }
        StructObjectInspector soi = (StructObjectInspector)objectInspector;
        List fields = soi.getAllStructFieldRefs();
        List values = soi.getStructFieldsDataAsList(o);
        HashMap<String, Object> value = new HashMap<String, Object>();
        for (int i = 0; i < this.columns.length; ++i) {
            Object res;
            if (values.get(i) == null) {
                value.put(this.columns[i], null);
                continue;
            }
            switch (this.types[i].getPrimitiveCategory()) {
                case TIMESTAMP: {
                    res = ((TimestampObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).getPrimitiveJavaObject(values.get(i)).getTime();
                    break;
                }
                case BYTE: {
                    res = ((ByteObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).get(values.get(i));
                    break;
                }
                case SHORT: {
                    res = ((ShortObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).get(values.get(i));
                    break;
                }
                case INT: {
                    res = ((IntObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).get(values.get(i));
                    break;
                }
                case LONG: {
                    res = ((LongObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).get(values.get(i));
                    break;
                }
                case FLOAT: {
                    res = Float.valueOf(((FloatObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).get(values.get(i)));
                    break;
                }
                case DOUBLE: {
                    res = ((DoubleObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).get(values.get(i));
                    break;
                }
                case DECIMAL: {
                    res = ((HiveDecimalObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).getPrimitiveJavaObject(values.get(i)).doubleValue();
                    break;
                }
                case CHAR: {
                    res = ((HiveCharObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).getPrimitiveJavaObject(values.get(i)).getValue();
                    break;
                }
                case VARCHAR: {
                    res = ((HiveVarcharObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).getPrimitiveJavaObject(values.get(i)).getValue();
                    break;
                }
                case STRING: {
                    res = ((StringObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).getPrimitiveJavaObject(values.get(i));
                    break;
                }
                case BOOLEAN: {
                    res = ((BooleanObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).get(values.get(i));
                    break;
                }
                default: {
                    throw new SerDeException("Unknown type: " + this.types[i].getPrimitiveCategory());
                }
            }
            value.put(this.columns[i], res);
        }
        value.put("__time_granularity", ((TimestampObjectInspector)((StructField)fields.get(this.columns.length)).getFieldObjectInspector()).getPrimitiveJavaObject(values.get(this.columns.length)).getTime());
        return new DruidWritable(value);
    }

    public SerDeStats getSerDeStats() {
        return null;
    }

    public Object deserialize(Writable writable) throws SerDeException {
        DruidWritable input = (DruidWritable)writable;
        ArrayList<Object> output = Lists.newArrayListWithExpectedSize(this.columns.length);
        block14: for (int i = 0; i < this.columns.length; ++i) {
            Object value = input.getValue().get(this.columns[i]);
            if (value == null) {
                output.add(null);
                continue;
            }
            switch (this.types[i].getPrimitiveCategory()) {
                case TIMESTAMP: {
                    output.add(new TimestampWritable(new Timestamp((Long)value)));
                    continue block14;
                }
                case BYTE: {
                    output.add(new ByteWritable(((Number)value).byteValue()));
                    continue block14;
                }
                case SHORT: {
                    output.add(new ShortWritable(((Number)value).shortValue()));
                    continue block14;
                }
                case INT: {
                    output.add(new IntWritable(((Number)value).intValue()));
                    continue block14;
                }
                case LONG: {
                    output.add(new LongWritable(((Number)value).longValue()));
                    continue block14;
                }
                case FLOAT: {
                    output.add(new FloatWritable(((Number)value).floatValue()));
                    continue block14;
                }
                case DOUBLE: {
                    output.add(new DoubleWritable(((Number)value).doubleValue()));
                    continue block14;
                }
                case DECIMAL: {
                    output.add(new HiveDecimalWritable(HiveDecimal.create((double)((Number)value).doubleValue())));
                    continue block14;
                }
                case CHAR: {
                    output.add(new HiveCharWritable(new HiveChar(value.toString(), ((CharTypeInfo)this.types[i]).getLength())));
                    continue block14;
                }
                case VARCHAR: {
                    output.add(new HiveVarcharWritable(new HiveVarchar(value.toString(), ((VarcharTypeInfo)this.types[i]).getLength())));
                    continue block14;
                }
                case STRING: {
                    output.add(new Text(value.toString()));
                    continue block14;
                }
                case BOOLEAN: {
                    output.add(new BooleanWritable(Boolean.valueOf(value.toString()).booleanValue()));
                    continue block14;
                }
                default: {
                    throw new SerDeException("Unknown type: " + this.types[i].getPrimitiveCategory());
                }
            }
        }
        return output;
    }

    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.inspector;
    }
}

