/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid.serde;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.druid.DruidStorageHandlerUtils;
import org.apache.hadoop.hive.druid.serde.DruidQueryRecordReader;
import org.apache.hadoop.hive.druid.serde.DruidWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JavaType;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.metamx.http.client.HttpClient;
import org.apache.hive.druid.io.druid.data.input.MapBasedRow;
import org.apache.hive.druid.io.druid.data.input.Row;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.dimension.ExtractionDimensionSpec;
import org.apache.hive.druid.io.druid.query.extraction.TimeFormatExtractionFn;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQuery;
import org.joda.time.format.ISODateTimeFormat;

public class DruidGroupByQueryRecordReader
extends DruidQueryRecordReader<GroupByQuery, Row> {
    private static final TypeReference<Row> TYPE_REFERENCE = new TypeReference<Row>(){};
    private MapBasedRow currentRow;
    private Map<String, Object> currentEvent;
    private List<String> timeExtractionFields = Lists.newArrayList();
    private List<String> intFormattedTimeExtractionFields = Lists.newArrayList();

    @Override
    public void initialize(InputSplit split, Configuration conf) throws IOException {
        super.initialize(split, conf);
        this.initDimensionTypes();
    }

    @Override
    public void initialize(InputSplit split, Configuration conf, ObjectMapper mapper, ObjectMapper smileMapper, HttpClient httpClient) throws IOException {
        super.initialize(split, conf, mapper, smileMapper, httpClient);
        this.initDimensionTypes();
    }

    @Override
    protected JavaType getResultTypeDef() {
        return DruidStorageHandlerUtils.JSON_MAPPER.getTypeFactory().constructType(TYPE_REFERENCE);
    }

    private void initDimensionTypes() throws IOException {
        List<DimensionSpec> dimensionSpecList = ((GroupByQuery)this.query).getDimensions();
        List extractionDimensionSpecList = dimensionSpecList.stream().filter(dimensionSpecs -> dimensionSpecs instanceof ExtractionDimensionSpec).collect(Collectors.toList());
        extractionDimensionSpecList.stream().forEach(dimensionSpec -> {
            ExtractionDimensionSpec extractionDimensionSpec = (ExtractionDimensionSpec)dimensionSpec;
            if (extractionDimensionSpec.getExtractionFn() instanceof TimeFormatExtractionFn) {
                TimeFormatExtractionFn timeFormatExtractionFn = (TimeFormatExtractionFn)extractionDimensionSpec.getExtractionFn();
                if (timeFormatExtractionFn == null || timeFormatExtractionFn.getFormat().equals("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")) {
                    this.timeExtractionFields.add(extractionDimensionSpec.getOutputName());
                } else {
                    this.intFormattedTimeExtractionFields.add(extractionDimensionSpec.getOutputName());
                }
            }
        });
    }

    @Override
    public boolean nextKeyValue() {
        if (this.queryResultsIterator.hasNext()) {
            Row row = (Row)this.queryResultsIterator.next();
            this.currentRow = (MapBasedRow)row;
            this.currentEvent = Maps.transformEntries(this.currentRow.getEvent(), (key, value1) -> {
                if (this.timeExtractionFields.contains(key)) {
                    return ISODateTimeFormat.dateTimeParser().parseMillis((String)value1);
                }
                if (this.intFormattedTimeExtractionFields.contains(key)) {
                    return Integer.valueOf((String)value1);
                }
                return value1;
            });
            return true;
        }
        return false;
    }

    @Override
    public NullWritable getCurrentKey() throws IOException, InterruptedException {
        return NullWritable.get();
    }

    @Override
    public DruidWritable getCurrentValue() throws IOException, InterruptedException {
        DruidWritable value = new DruidWritable();
        value.getValue().put("__time", this.currentRow.getTimestamp().getMillis());
        value.getValue().putAll(this.currentEvent);
        return value;
    }

    @Override
    public boolean next(NullWritable key, DruidWritable value) {
        if (this.nextKeyValue()) {
            value.getValue().clear();
            value.getValue().put("__time", this.currentRow.getTimestamp().getMillis());
            value.getValue().putAll(this.currentEvent);
            return true;
        }
        return false;
    }

    @Override
    public float getProgress() throws IOException {
        return this.queryResultsIterator.hasNext() ? 0.0f : 1.0f;
    }
}

