/*
 * Decompiled with CFR 0.152.
 */
package io.druid.java.util.common.parsers;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.druid.java.util.common.collect.Utils;
import io.druid.java.util.common.parsers.ParseException;
import io.druid.java.util.common.parsers.Parser;
import io.druid.java.util.common.parsers.ParserUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class RegexParser
implements Parser<String, Object> {
    private final String pattern;
    private final Splitter listSplitter;
    private final Function<String, Object> valueFunction;
    private final Pattern compiled;
    private List<String> fieldNames = null;

    public RegexParser(String pattern, Optional<String> listDelimiter) {
        this.pattern = pattern;
        this.listSplitter = Splitter.onPattern((String)(listDelimiter.isPresent() ? (String)listDelimiter.get() : "\u0001"));
        this.valueFunction = new Function<String, Object>(){

            public Object apply(String input) {
                List retVal = StreamSupport.stream(RegexParser.this.listSplitter.split((CharSequence)input).spliterator(), false).map(Strings::emptyToNull).collect(Collectors.toList());
                if (retVal.size() == 1) {
                    return retVal.get(0);
                }
                return retVal;
            }
        };
        this.compiled = Pattern.compile(pattern);
    }

    public RegexParser(String pattern, Optional<String> listDelimiter, Iterable<String> fieldNames) {
        this(pattern, listDelimiter);
        this.setFieldNames(fieldNames);
    }

    @Override
    public Map<String, Object> parseToMap(String input) {
        try {
            Matcher matcher = this.compiled.matcher(input);
            if (!matcher.matches()) {
                throw new ParseException("Incorrect Regex: %s . No match found.", this.pattern);
            }
            ArrayList values = Lists.newArrayList();
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                values.add(matcher.group(i));
            }
            if (this.fieldNames == null) {
                this.setFieldNames(ParserUtils.generateFieldNames(values.size()));
            }
            return Utils.zipMapPartial(this.fieldNames, Iterables.transform((Iterable)values, this.valueFunction));
        }
        catch (Exception e) {
            throw new ParseException(e, "Unable to parse row [%s]", input);
        }
    }

    @Override
    public void setFieldNames(Iterable<String> fieldNames) {
        ParserUtils.validateFields(fieldNames);
        this.fieldNames = Lists.newArrayList(fieldNames);
    }

    @Override
    public List<String> getFieldNames() {
        return this.fieldNames;
    }
}

