/*
 * Decompiled with CFR 0.152.
 */
package io.druid.java.util.common.parsers;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.druid.java.util.common.parsers.JSONPathFieldType;
import java.util.Objects;

public class JSONPathFieldSpec {
    private final JSONPathFieldType type;
    private final String name;
    private final String expr;

    @JsonCreator
    public JSONPathFieldSpec(@JsonProperty(value="type") JSONPathFieldType type, @JsonProperty(value="name") String name, @JsonProperty(value="expr") String expr) {
        this.type = type;
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Missing 'name' in field spec");
        this.expr = expr == null && type == JSONPathFieldType.ROOT ? name : (String)Preconditions.checkNotNull((Object)expr, (String)"Missing 'expr' for field[%s]", (Object[])new Object[]{name});
    }

    @JsonProperty
    public JSONPathFieldType getType() {
        return this.type;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getExpr() {
        return this.expr;
    }

    @JsonCreator
    public static JSONPathFieldSpec fromString(String name) {
        return JSONPathFieldSpec.createRootField(name);
    }

    public static JSONPathFieldSpec createNestedField(String name, String expr) {
        return new JSONPathFieldSpec(JSONPathFieldType.PATH, name, expr);
    }

    public static JSONPathFieldSpec createJqField(String name, String expr) {
        return new JSONPathFieldSpec(JSONPathFieldType.JQ, name, expr);
    }

    public static JSONPathFieldSpec createRootField(String name) {
        return new JSONPathFieldSpec(JSONPathFieldType.ROOT, name, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSONPathFieldSpec that = (JSONPathFieldSpec)o;
        return this.type == that.type && Objects.equals(this.name, that.name) && Objects.equals(this.expr, that.expr);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.name, this.expr});
    }

    public String toString() {
        return "JSONPathFieldSpec{type=" + (Object)((Object)this.type) + ", name='" + this.name + '\'' + ", expr='" + this.expr + '\'' + '}';
    }
}

