/*
 * Decompiled with CFR 0.152.
 */
package io.druid.java.util.common.guava;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;

public class MergeIterator<T>
implements Iterator<T> {
    private final PriorityQueue<PeekingIterator<T>> pQueue;

    public MergeIterator(final Comparator<T> comparator, List<Iterator<T>> iterators) {
        this.pQueue = new PriorityQueue(16, new Comparator<PeekingIterator<T>>(){

            @Override
            public int compare(PeekingIterator<T> lhs, PeekingIterator<T> rhs) {
                return comparator.compare(lhs.peek(), rhs.peek());
            }
        });
        for (Iterator<T> iterator : iterators) {
            PeekingIterator iter = Iterators.peekingIterator(iterator);
            if (iter == null || !iter.hasNext()) continue;
            this.pQueue.add(iter);
        }
    }

    @Override
    public boolean hasNext() {
        return !this.pQueue.isEmpty();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        PeekingIterator retIt = (PeekingIterator)this.pQueue.remove();
        Object retVal = retIt.next();
        if (retIt.hasNext()) {
            this.pQueue.add(retIt);
        }
        return (T)retVal;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

