/*
 * Decompiled with CFR 0.152.
 */
package io.druid.java.util.metrics;

import com.google.common.collect.ImmutableMap;
import io.druid.java.util.emitter.core.HttpPostEmitter;
import io.druid.java.util.emitter.core.ParametrizedUriEmitter;
import io.druid.java.util.emitter.service.ServiceEmitter;
import io.druid.java.util.metrics.AbstractMonitor;
import io.druid.java.util.metrics.FeedDefiningMonitor;
import io.druid.java.util.metrics.HttpPostEmitterMonitor;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class ParametrizedUriEmitterMonitor
extends FeedDefiningMonitor {
    private final ParametrizedUriEmitter parametrizedUriEmitter;
    private final Map<URI, HttpPostEmitterMonitor> monitors = new HashMap<URI, HttpPostEmitterMonitor>();

    public ParametrizedUriEmitterMonitor(String feed, ParametrizedUriEmitter parametrizedUriEmitter) {
        super(feed);
        this.parametrizedUriEmitter = parametrizedUriEmitter;
    }

    private void updateMonitors() {
        this.parametrizedUriEmitter.forEachEmitter((uri, emitter) -> this.monitors.computeIfAbsent((URI)uri, u -> {
            HttpPostEmitterMonitor monitor = new HttpPostEmitterMonitor(this.feed, (HttpPostEmitter)emitter, (ImmutableMap<String, String>)ImmutableMap.of((Object)"uri", (Object)uri.toString()));
            monitor.start();
            return monitor;
        }));
    }

    @Override
    public void stop() {
        this.monitors.values().forEach(AbstractMonitor::stop);
        super.stop();
    }

    @Override
    public boolean doMonitor(ServiceEmitter emitter) {
        this.updateMonitors();
        this.monitors.values().forEach(m -> m.doMonitor(emitter));
        return true;
    }
}

