/*
 * Decompiled with CFR 0.152.
 */
package io.druid.common.config;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import io.druid.common.config.NullValueHandlingConfig;
import javax.annotation.Nullable;

public class NullHandling {
    public static String NULL_HANDLING_CONFIG_STRING = "druid.generic.useDefaultValueForNull";
    public static final Double ZERO_DOUBLE = 0.0;
    public static final Float ZERO_FLOAT = Float.valueOf(0.0f);
    public static final Long ZERO_LONG = 0L;
    @Inject
    private static NullValueHandlingConfig INSTANCE = new NullValueHandlingConfig(Boolean.valueOf(System.getProperty(NULL_HANDLING_CONFIG_STRING, "false")));

    public static boolean replaceWithDefault() {
        return INSTANCE.isUseDefaultValuesForNull();
    }

    public static boolean sqlCompatible() {
        return !NullHandling.replaceWithDefault();
    }

    @Nullable
    public static String nullToEmptyIfNeeded(@Nullable String value) {
        return NullHandling.replaceWithDefault() ? Strings.nullToEmpty((String)value) : value;
    }

    @Nullable
    public static String emptyToNullIfNeeded(@Nullable String value) {
        return NullHandling.replaceWithDefault() ? Strings.emptyToNull((String)value) : value;
    }

    @Nullable
    public static String defaultStringValue() {
        return NullHandling.replaceWithDefault() ? "" : null;
    }

    @Nullable
    public static Long defaultLongValue() {
        return NullHandling.replaceWithDefault() ? ZERO_LONG : null;
    }

    @Nullable
    public static Float defaultFloatValue() {
        return NullHandling.replaceWithDefault() ? ZERO_FLOAT : null;
    }

    @Nullable
    public static Double defaultDoubleValue() {
        return NullHandling.replaceWithDefault() ? ZERO_DOUBLE : null;
    }

    public static boolean isNullOrEquivalent(@Nullable String value) {
        return NullHandling.replaceWithDefault() ? Strings.isNullOrEmpty((String)value) : value == null;
    }
}

