/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.metrics;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.emitter.service.ServiceMetricEvent;
import com.metamx.metrics.FeedDefiningMonitor;
import com.metamx.metrics.JvmPidDiscoverer;
import com.metamx.metrics.MonitorUtils;
import com.metamx.metrics.PidDiscoverer;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gridkit.lab.jvm.perfdata.JStatData;

public class JvmMonitor
extends FeedDefiningMonitor {
    private final Map<String, String[]> dimensions;
    private final long pid;
    private final GcCounters gcCounters = new GcCounters();

    public JvmMonitor() {
        this((Map<String, String[]>)ImmutableMap.of());
    }

    public JvmMonitor(Map<String, String[]> dimensions) {
        this(dimensions, "metrics");
    }

    public JvmMonitor(Map<String, String[]> dimensions, String feed) {
        this(dimensions, feed, JvmPidDiscoverer.instance());
    }

    public JvmMonitor(Map<String, String[]> dimensions, String feed, PidDiscoverer pidDiscoverer) {
        super(feed);
        Preconditions.checkNotNull(dimensions);
        this.dimensions = ImmutableMap.copyOf(dimensions);
        this.pid = ((PidDiscoverer)Preconditions.checkNotNull((Object)pidDiscoverer)).getPid();
    }

    @Override
    public boolean doMonitor(ServiceEmitter emitter) {
        this.emitJvmMemMetrics(emitter);
        this.emitDirectMemMetrics(emitter);
        this.emitGcMetrics(emitter);
        return true;
    }

    @Deprecated
    private void emitJvmMemMetrics(ServiceEmitter emitter) {
        ServiceMetricEvent.Builder builder;
        MemoryUsage usage;
        String kind;
        ImmutableMap usages = ImmutableMap.of((Object)"heap", (Object)ManagementFactory.getMemoryMXBean().getHeapMemoryUsage(), (Object)"nonheap", (Object)ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage());
        for (Map.Entry entry : usages.entrySet()) {
            kind = (String)entry.getKey();
            usage = (MemoryUsage)entry.getValue();
            builder = this.builder().setDimension("memKind", kind);
            MonitorUtils.addDimensionsToBuilder(builder, this.dimensions);
            emitter.emit(builder.build("jvm/mem/max", (Number)usage.getMax()));
            emitter.emit(builder.build("jvm/mem/committed", (Number)usage.getCommitted()));
            emitter.emit(builder.build("jvm/mem/used", (Number)usage.getUsed()));
            emitter.emit(builder.build("jvm/mem/init", (Number)usage.getInit()));
        }
        for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
            kind = pool.getType() == MemoryType.HEAP ? "heap" : "nonheap";
            usage = pool.getUsage();
            builder = this.builder().setDimension("poolKind", kind).setDimension("poolName", pool.getName());
            MonitorUtils.addDimensionsToBuilder(builder, this.dimensions);
            emitter.emit(builder.build("jvm/pool/max", (Number)usage.getMax()));
            emitter.emit(builder.build("jvm/pool/committed", (Number)usage.getCommitted()));
            emitter.emit(builder.build("jvm/pool/used", (Number)usage.getUsed()));
            emitter.emit(builder.build("jvm/pool/init", (Number)usage.getInit()));
        }
    }

    private void emitDirectMemMetrics(ServiceEmitter emitter) {
        for (BufferPoolMXBean pool : ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class)) {
            ServiceMetricEvent.Builder builder = this.builder().setDimension("bufferpoolName", pool.getName());
            MonitorUtils.addDimensionsToBuilder(builder, this.dimensions);
            emitter.emit(builder.build("jvm/bufferpool/capacity", (Number)pool.getTotalCapacity()));
            emitter.emit(builder.build("jvm/bufferpool/used", (Number)pool.getMemoryUsed()));
            emitter.emit(builder.build("jvm/bufferpool/count", (Number)pool.getCount()));
        }
    }

    private void emitGcMetrics(ServiceEmitter emitter) {
        this.gcCounters.emit(emitter, this.dimensions);
    }

    private class GcGenerationSpace {
        private final String name;
        private final JStatData.LongCounter maxCounter;
        private final JStatData.LongCounter capacityCounter;
        private final JStatData.LongCounter usedCounter;
        private final JStatData.LongCounter initCounter;

        GcGenerationSpace(Map<String, JStatData.Counter<?>> jStatCounters, long genIndex, long spaceIndex) {
            String spaceKeyPrefix = String.format("sun.gc.generation.%d.space.%d", genIndex, spaceIndex);
            String nameKey = String.format("%s.name", spaceKeyPrefix);
            JStatData.StringCounter nameCounter = (JStatData.StringCounter)jStatCounters.get(nameKey);
            this.name = nameCounter.toString().toLowerCase();
            this.maxCounter = (JStatData.LongCounter)jStatCounters.get(String.format("%s.maxCapacity", spaceKeyPrefix));
            this.capacityCounter = (JStatData.LongCounter)jStatCounters.get(String.format("%s.capacity", spaceKeyPrefix));
            this.usedCounter = (JStatData.LongCounter)jStatCounters.get(String.format("%s.used", spaceKeyPrefix));
            this.initCounter = (JStatData.LongCounter)jStatCounters.get(String.format("%s.initCapacity", spaceKeyPrefix));
        }

        void emit(ServiceEmitter emitter, Map<String, String[]> dimensions) {
            ServiceMetricEvent.Builder builder = JvmMonitor.this.builder();
            MonitorUtils.addDimensionsToBuilder(builder, dimensions);
            builder.setDimension("gcGenSpaceName", this.name);
            emitter.emit(builder.build("jvm/gc/mem/max", (Number)this.maxCounter.getLong()));
            emitter.emit(builder.build("jvm/gc/mem/capacity", (Number)this.capacityCounter.getLong()));
            emitter.emit(builder.build("jvm/gc/mem/used", (Number)this.usedCounter.getLong()));
            emitter.emit(builder.build("jvm/gc/mem/init", (Number)this.initCounter.getLong()));
        }
    }

    private class GcGenerationCollector {
        private final String name;
        private final JStatData.LongCounter invocationsCounter;
        private final JStatData.TickCounter cpuCounter;
        private long lastInvocations = 0L;
        private long lastCpuNanos = 0L;

        GcGenerationCollector(Map<String, JStatData.Counter<?>> jStatCounters, long genIndex) {
            String collectorKeyPrefix = String.format("sun.gc.collector.%d", genIndex);
            String nameKey = String.format("%s.name", collectorKeyPrefix);
            JStatData.StringCounter nameCounter = (JStatData.StringCounter)jStatCounters.get(nameKey);
            this.name = this.getReadableName(nameCounter.getString());
            this.invocationsCounter = (JStatData.LongCounter)jStatCounters.get(String.format("%s.invocations", collectorKeyPrefix));
            this.cpuCounter = (JStatData.TickCounter)jStatCounters.get(String.format("%s.time", collectorKeyPrefix));
        }

        void emit(ServiceEmitter emitter, Map<String, String[]> dimensions) {
            ServiceMetricEvent.Builder builder = JvmMonitor.this.builder();
            MonitorUtils.addDimensionsToBuilder(builder, dimensions);
            long newInvocations = this.invocationsCounter.getLong();
            emitter.emit(builder.build("jvm/gc/count", (Number)(newInvocations - this.lastInvocations)));
            this.lastInvocations = newInvocations;
            long newCpuNanos = this.cpuCounter.getNanos();
            emitter.emit(builder.build("jvm/gc/cpu", (Number)(newCpuNanos - this.lastCpuNanos)));
            this.lastCpuNanos = newCpuNanos;
        }

        private String getReadableName(String name) {
            switch (name) {
                case "Copy": {
                    return "serial";
                }
                case "PSScavenge": {
                    return "parallel";
                }
                case "PCopy": {
                    return "cms";
                }
                case "G1 incremental collections": {
                    return "g1";
                }
                case "MCS": {
                    return "serial";
                }
                case "PSParallelCompact": {
                    return "parallel";
                }
                case "CMS": {
                    return "cms";
                }
                case "G1 stop-the-world full collections": {
                    return "g1";
                }
            }
            return name;
        }
    }

    private class GcGeneration {
        private final String name;
        private final GcGenerationCollector collector;
        private final List<GcGenerationSpace> spaces = new ArrayList<GcGenerationSpace>();

        GcGeneration(Map<String, JStatData.Counter<?>> jStatCounters, long genIndex, String name) {
            this.name = name.toLowerCase();
            long spacesCount = ((JStatData.LongCounter)jStatCounters.get(String.format("sun.gc.generation.%d.spaces", genIndex))).getLong();
            for (long spaceIndex = 0L; spaceIndex < spacesCount; ++spaceIndex) {
                this.spaces.add(new GcGenerationSpace(jStatCounters, genIndex, spaceIndex));
            }
            this.collector = jStatCounters.containsKey(String.format("sun.gc.collector.%d.name", genIndex)) ? new GcGenerationCollector(jStatCounters, genIndex) : null;
        }

        void emit(ServiceEmitter emitter, Map<String, String[]> dimensions) {
            ImmutableMap.Builder dimensionsCopyBuilder = ImmutableMap.builder().putAll(dimensions).put((Object)"gcGen", (Object)new String[]{this.name});
            if (this.collector != null) {
                dimensionsCopyBuilder.put((Object)"gcName", (Object)new String[]{this.collector.name});
            }
            ImmutableMap dimensionsCopy = dimensionsCopyBuilder.build();
            if (this.collector != null) {
                this.collector.emit(emitter, (Map<String, String[]>)dimensionsCopy);
            }
            for (GcGenerationSpace space : this.spaces) {
                space.emit(emitter, (Map<String, String[]>)dimensionsCopy);
            }
        }
    }

    private class GcCounters {
        private final List<GcGeneration> generations = new ArrayList<GcGeneration>();

        GcCounters() {
            JStatData jStatData = JStatData.connect((long)JvmMonitor.this.pid);
            Map jStatCounters = jStatData.getAllCounters();
            this.generations.add(new GcGeneration(jStatCounters, 0L, "young"));
            this.generations.add(new GcGeneration(jStatCounters, 1L, "old"));
            if (jStatCounters.containsKey("sun.gc.generation.2.name")) {
                this.generations.add(new GcGeneration(jStatCounters, 2L, "perm"));
            }
        }

        void emit(ServiceEmitter emitter, Map<String, String[]> dimensions) {
            for (GcGeneration generation : this.generations) {
                generation.emit(emitter, dimensions);
            }
        }
    }
}

