/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.metrics.cgroups;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import com.metamx.common.RE;
import com.metamx.metrics.CgroupUtil;
import com.metamx.metrics.cgroups.CgroupDiscoverer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class ProcCgroupDiscoverer
implements CgroupDiscoverer {
    private static final String CGROUP_TYPE = "cgroup";
    private static final String PROC_TYPE = "getProc";

    @Override
    public Path discover(String cgroup, long pid) {
        Preconditions.checkNotNull((Object)cgroup, (Object)"cgroup required");
        File proc = this.getProc();
        File procMounts = new File(proc, "mounts");
        File procCgroups = new File(proc, "cgroups");
        File pidCgroups = new File(new File(proc, Long.toString(pid)), CGROUP_TYPE);
        ProcCgroupsEntry procCgroupsEntry = this.getCgroupEntry(procCgroups, cgroup);
        ProcMountsEntry procMountsEntry = this.getMountEntry(procMounts, cgroup);
        ProcPidCgroupEntry procPidCgroupEntry = this.getPidCgroupEntry(pidCgroups, procCgroupsEntry.hierarchy);
        File cgroupDir = new File(procMountsEntry.path.toFile(), procPidCgroupEntry.path);
        if (cgroupDir.exists() && cgroupDir.isDirectory()) {
            return cgroupDir.toPath();
        }
        throw new RE("Invalid cgroup directory [%s]", new Object[]{cgroupDir});
    }

    @VisibleForTesting
    public File getProc() {
        File proc = new File("/proc");
        Path foundProc = null;
        if (proc.exists() && proc.isDirectory()) {
            try {
                for (String line : Files.readLines((File)new File(proc, "mounts"), (Charset)Charsets.UTF_8)) {
                    ProcMountsEntry entry = ProcMountsEntry.parse(line);
                    if (!PROC_TYPE.equals(entry.type)) continue;
                    if (proc.toPath().equals(entry.path)) {
                        return proc;
                    }
                    foundProc = entry.path;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (foundProc != null) {
                throw new RE("Expected proc to be mounted on /proc, but was on [%s]", new Object[]{foundProc});
            }
            throw new RE("No proc entry found in /proc/mounts", new Object[0]);
        }
        throw new RE("/proc is not a valid directory", new Object[0]);
    }

    private ProcPidCgroupEntry getPidCgroupEntry(File pidCgroups, int hierarchy) {
        List lines;
        try {
            lines = Files.readLines((File)pidCgroups, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (String line : lines) {
            ProcPidCgroupEntry entry = ProcPidCgroupEntry.parse(line);
            if (hierarchy != entry.hierarchy) continue;
            return entry;
        }
        throw new RE("No hierarchy found for [%d]", new Object[]{hierarchy});
    }

    private ProcCgroupsEntry getCgroupEntry(File procCgroups, String cgroup) {
        List lines;
        try {
            lines = Files.readLines((File)procCgroups, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (String line : lines) {
            if (line.startsWith("#")) continue;
            ProcCgroupsEntry entry = ProcCgroupsEntry.parse(line);
            if (!entry.enabled || !cgroup.equals(entry.subsystem_name)) continue;
            return entry;
        }
        throw new RE("Hierarchy for [%s] not found", new Object[]{cgroup});
    }

    private ProcMountsEntry getMountEntry(File procMounts, String cgroup) {
        List lines;
        try {
            lines = Files.readLines((File)procMounts, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (String line : lines) {
            ProcMountsEntry entry = ProcMountsEntry.parse(line);
            if (!CGROUP_TYPE.equals(entry.type) || !entry.options.contains(cgroup)) continue;
            return entry;
        }
        throw new RE("Cgroup [%s] not found", new Object[]{cgroup});
    }

    static class ProcPidCgroupEntry {
        private final int hierarchy;
        private final String entrypoint;
        private final String path;

        static ProcPidCgroupEntry parse(String entry) {
            String[] splits = entry.split(CgroupUtil.COLON_MATCH, 3);
            Preconditions.checkArgument((splits.length == 3 ? 1 : 0) != 0, (String)"Invalid entry [%s]", (Object[])new Object[]{entry});
            return new ProcPidCgroupEntry(Integer.parseInt(splits[0]), splits[1], splits[2]);
        }

        ProcPidCgroupEntry(int hierarchy, String entrypoint, String path) {
            this.hierarchy = hierarchy;
            this.entrypoint = entrypoint;
            this.path = path;
        }
    }

    static class ProcCgroupsEntry {
        final String subsystem_name;
        final int hierarchy;
        final int num_cgroups;
        final boolean enabled;

        static ProcCgroupsEntry parse(String entry) {
            String[] splits = entry.split(Pattern.quote("\t"));
            return new ProcCgroupsEntry(splits[0], Integer.parseInt(splits[1]), Integer.parseInt(splits[2]), Integer.parseInt(splits[3]) == 1);
        }

        ProcCgroupsEntry(String subsystem_name, int hierarchy, int num_cgroups, boolean enabled) {
            this.subsystem_name = subsystem_name;
            this.hierarchy = hierarchy;
            this.num_cgroups = num_cgroups;
            this.enabled = enabled;
        }
    }

    static class ProcMountsEntry {
        final String dev;
        final Path path;
        final String type;
        final Set<String> options;

        static ProcMountsEntry parse(String entry) {
            String[] splits = entry.split(CgroupUtil.SPACE_MATCH, 6);
            Preconditions.checkArgument((splits.length == 6 ? 1 : 0) != 0, (String)"Invalid entry: [%s]", (Object[])new Object[]{entry});
            return new ProcMountsEntry(splits[0], Paths.get(splits[1], new String[0]), splits[2], (Collection<String>)ImmutableSet.copyOf((Object[])splits[3].split(CgroupUtil.COMMA_MATCH)));
        }

        ProcMountsEntry(String dev, Path path, String type, Collection<String> options) {
            this.dev = dev;
            this.path = path;
            this.type = type;
            this.options = ImmutableSet.copyOf(options);
        }
    }
}

