/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.metrics;

import com.metamx.metrics.CompoundMonitor;
import com.metamx.metrics.JvmCpuMonitor;
import com.metamx.metrics.JvmMonitor;
import com.metamx.metrics.JvmThreadsMonitor;
import com.metamx.metrics.Monitor;
import java.util.List;
import java.util.Map;

public class Monitors {
    public static Monitor createCompoundJvmMonitor(Map<String, String[]> dimensions) {
        return Monitors.and(new JvmMonitor(dimensions), new JvmCpuMonitor(dimensions), new JvmThreadsMonitor(dimensions));
    }

    public static Monitor and(Monitor ... monitors) {
        return new CompoundMonitor(monitors){

            @Override
            public boolean shouldReschedule(List<Boolean> reschedules) {
                boolean b = true;
                for (boolean reschedule : reschedules) {
                    b = b && reschedule;
                }
                return b;
            }
        };
    }

    public static Monitor or(Monitor ... monitors) {
        return new CompoundMonitor(monitors){

            @Override
            public boolean shouldReschedule(List<Boolean> reschedules) {
                boolean b = false;
                for (boolean reschedule : reschedules) {
                    b = b || reschedule;
                }
                return b;
            }
        };
    }
}

