/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.metrics;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.emitter.service.ServiceMetricEvent;
import com.metamx.metrics.AbstractMonitor;
import com.metamx.metrics.MonitorUtils;
import com.metamx.metrics.SigarUtil;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.Map;
import org.gridkit.lab.jvm.perfdata.JStatData;

public class JvmMonitor
extends AbstractMonitor {
    private final GcCounters youngGcCounters;
    private final GcCounters oldGcCounters;
    private final Map<String, String[]> dimensions;

    public JvmMonitor() {
        this((Map<String, String[]>)ImmutableMap.of());
    }

    public JvmMonitor(Map<String, String[]> dimensions) {
        long currentProcessId = SigarUtil.getCurrentProcessId();
        JStatData jStatData = JStatData.connect((long)currentProcessId);
        Map jStatCounters = jStatData.getAllCounters();
        this.youngGcCounters = new GcCounters(jStatCounters, GcGeneration.YOUNG);
        this.oldGcCounters = new GcCounters(jStatCounters, GcGeneration.OLD);
        Preconditions.checkNotNull(dimensions);
        this.dimensions = ImmutableMap.copyOf(dimensions);
    }

    @Override
    public boolean doMonitor(ServiceEmitter emitter) {
        ServiceMetricEvent.Builder builder;
        MemoryUsage usage;
        String kind;
        ImmutableMap usages = ImmutableMap.of((Object)"heap", (Object)ManagementFactory.getMemoryMXBean().getHeapMemoryUsage(), (Object)"nonheap", (Object)ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage());
        for (Map.Entry entry : usages.entrySet()) {
            kind = (String)entry.getKey();
            usage = (MemoryUsage)entry.getValue();
            builder = new ServiceMetricEvent.Builder().setDimension("memKind", kind);
            MonitorUtils.addDimensionsToBuilder(builder, this.dimensions);
            emitter.emit(builder.build("jvm/mem/max", (Number)usage.getMax()));
            emitter.emit(builder.build("jvm/mem/committed", (Number)usage.getCommitted()));
            emitter.emit(builder.build("jvm/mem/used", (Number)usage.getUsed()));
            emitter.emit(builder.build("jvm/mem/init", (Number)usage.getInit()));
        }
        for (MemoryPoolMXBean memoryPoolMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
            kind = memoryPoolMXBean.getType() == MemoryType.HEAP ? "heap" : "nonheap";
            usage = memoryPoolMXBean.getUsage();
            builder = new ServiceMetricEvent.Builder().setDimension("poolKind", kind).setDimension("poolName", memoryPoolMXBean.getName());
            MonitorUtils.addDimensionsToBuilder(builder, this.dimensions);
            emitter.emit(builder.build("jvm/pool/max", (Number)usage.getMax()));
            emitter.emit(builder.build("jvm/pool/committed", (Number)usage.getCommitted()));
            emitter.emit(builder.build("jvm/pool/used", (Number)usage.getUsed()));
            emitter.emit(builder.build("jvm/pool/init", (Number)usage.getInit()));
        }
        this.emitGcMetrics(this.youngGcCounters, emitter);
        this.emitGcMetrics(this.oldGcCounters, emitter);
        for (BufferPoolMXBean bufferPoolMXBean : ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class)) {
            ServiceMetricEvent.Builder builder2 = new ServiceMetricEvent.Builder().setDimension("bufferpoolName", bufferPoolMXBean.getName());
            MonitorUtils.addDimensionsToBuilder(builder2, this.dimensions);
            emitter.emit(builder2.build("jvm/bufferpool/capacity", (Number)bufferPoolMXBean.getTotalCapacity()));
            emitter.emit(builder2.build("jvm/bufferpool/used", (Number)bufferPoolMXBean.getMemoryUsed()));
            emitter.emit(builder2.build("jvm/bufferpool/count", (Number)bufferPoolMXBean.getCount()));
        }
        return true;
    }

    private void emitGcMetrics(GcCounters gcCounters, ServiceEmitter emitter) {
        ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder();
        MonitorUtils.addDimensionsToBuilder(builder, this.dimensions);
        gcCounters.emitCounters(emitter, builder);
    }

    private static class GcCounters {
        final GcGeneration generation;
        final JStatData.LongCounter invocations;
        final JStatData.TickCounter cpu;
        final String readableGcName;
        long lastInvocations = 0L;
        long lastCpuNanos = 0L;

        GcCounters(Map<String, JStatData.Counter<?>> jStatCounters, GcGeneration generation) {
            this.generation = generation;
            int jStatOrder = generation.jStatOrder;
            this.invocations = (JStatData.LongCounter)jStatCounters.get(String.format("sun.gc.collector.%d.invocations", jStatOrder));
            this.cpu = (JStatData.TickCounter)jStatCounters.get(String.format("sun.gc.collector.%d.time", jStatOrder));
            String gcName = ((JStatData.StringCounter)jStatCounters.get(String.format("sun.gc.collector.%d.name", jStatOrder))).getString();
            this.readableGcName = generation.readableGcName(gcName);
        }

        void emitCounters(ServiceEmitter emitter, ServiceMetricEvent.Builder metricBuilder) {
            metricBuilder.setDimension("gcGen", this.generation.name().toLowerCase());
            metricBuilder.setDimension("gcName", this.readableGcName);
            this.emitInvocations(emitter, metricBuilder);
            this.emitCpu(emitter, metricBuilder);
        }

        private void emitInvocations(ServiceEmitter emitter, ServiceMetricEvent.Builder metricBuilder) {
            long newInvocations = this.invocations.getLong();
            emitter.emit(metricBuilder.build("jvm/gc/count", (Number)(newInvocations - this.lastInvocations)));
            this.lastInvocations = newInvocations;
        }

        private void emitCpu(ServiceEmitter emitter, ServiceMetricEvent.Builder metricBuilder) {
            long newCpuNanos = this.cpu.getNanos();
            emitter.emit(metricBuilder.build("jvm/gc/cpu", (Number)(newCpuNanos - this.lastCpuNanos)));
            this.lastCpuNanos = newCpuNanos;
        }
    }

    private static enum GcGeneration {
        YOUNG(0){

            @Override
            String readableGcName(String name) {
                switch (name) {
                    case "Copy": {
                        return "serial";
                    }
                    case "PSScavenge": {
                        return "parallel";
                    }
                    case "PCopy": {
                        return "cms";
                    }
                    case "G1 incremental collections": {
                        return "g1";
                    }
                }
                return name;
            }
        }
        ,
        OLD(1){

            @Override
            String readableGcName(String name) {
                switch (name) {
                    case "MCS": {
                        return "serial";
                    }
                    case "PSParallelCompact": {
                        return "parallel";
                    }
                    case "CMS": {
                        return "cms";
                    }
                    case "G1 stop-the-world full collections": {
                        return "g1";
                    }
                }
                return name;
            }
        };

        final int jStatOrder;

        private GcGeneration(int jStatOrder) {
            this.jStatOrder = jStatOrder;
        }

        abstract String readableGcName(String var1);
    }
}

