/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.metrics;

import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.metamx.common.StreamUtils;
import com.metamx.common.logger.Logger;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.emitter.service.ServiceMetricEvent;
import com.metamx.metrics.AbstractMonitor;
import com.metamx.metrics.KeyedDiff;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.hyperic.sigar.DirUsage;
import org.hyperic.sigar.DiskUsage;
import org.hyperic.sigar.FileSystemUsage;
import org.hyperic.sigar.Mem;
import org.hyperic.sigar.NetInterfaceConfig;
import org.hyperic.sigar.NetInterfaceStat;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarLoader;
import org.hyperic.sigar.Swap;

public class SysMonitor
extends AbstractMonitor {
    private static final Logger log = new Logger(SysMonitor.class);
    private final Sigar sigar = new Sigar();
    private final List<String> fsTypeWhitelist = ImmutableList.of((Object)"local");
    private final List<String> netAddressBlacklist = ImmutableList.of((Object)"0.0.0.0", (Object)"127.0.0.1");
    private final List<Stats> statsList = new ArrayList<Stats>();

    public SysMonitor() {
        this.statsList.addAll(Arrays.asList(new MemStats(), new FsStats(), new DiskStats(), new NetStats(), new CpuStats(), new SwapStats()));
    }

    public void addDirectoriesToMonitor(String[] dirList) {
        for (int i = 0; i < dirList.length; ++i) {
            dirList[i] = dirList[i].trim();
        }
        this.statsList.add(new DirStats(dirList));
    }

    @Override
    public boolean doMonitor(ServiceEmitter emitter) {
        for (Stats stats : this.statsList) {
            stats.emit(emitter);
        }
        return true;
    }

    static {
        SigarLoader loader = new SigarLoader(Sigar.class);
        try {
            String libName = loader.getLibraryName();
            URL url = SysMonitor.class.getResource("/" + libName);
            if (url != null) {
                File tmpDir = File.createTempFile("yay", "yay");
                tmpDir.delete();
                tmpDir.mkdir();
                File nativeLibTmpFile = new File(tmpDir, libName);
                nativeLibTmpFile.deleteOnExit();
                StreamUtils.copyToFileAndClose((InputStream)url.openStream(), (File)nativeLibTmpFile);
                log.info("Loading sigar native lib at tmpPath[%s]", new Object[]{nativeLibTmpFile});
                loader.load(nativeLibTmpFile.getParent());
            } else {
                log.info("No native libs found in jar, letting the normal load mechanisms figger it out.", new Object[0]);
            }
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private class CpuStats
    implements Stats {
        private final KeyedDiff diff = new KeyedDiff();

        private CpuStats() {
        }

        @Override
        public void emit(ServiceEmitter emitter) {
            Object[] cpus = null;
            try {
                cpus = SysMonitor.this.sigar.getCpuList();
            }
            catch (SigarException e) {
                log.error((Throwable)e, "Failed to get Cpu list", new Object[0]);
            }
            if (cpus != null) {
                log.debug("Found Cpu list: [%s]", new Object[]{Joiner.on((String)", ").join(cpus)});
                for (int i = 0; i < cpus.length; ++i) {
                    Object cpu = cpus[i];
                    String name = Integer.toString(i);
                    Map<String, Long> stats = this.diff.to(name, (Map<String, Long>)ImmutableMap.of((Object)"user", (Object)cpu.getUser(), (Object)"sys", (Object)cpu.getSys(), (Object)"nice", (Object)cpu.getNice(), (Object)"wait", (Object)cpu.getWait(), (Object)"_total", (Object)cpu.getTotal()));
                    if (stats == null) continue;
                    long total = stats.remove("_total");
                    for (Map.Entry<String, Long> entry : stats.entrySet()) {
                        ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder().setUser1(name).setUser2(entry.getKey());
                        emitter.emit(builder.build("sys/cpu", (Number)(entry.getValue() * 100L / total)));
                    }
                }
            }
        }
    }

    private class NetStats
    implements Stats {
        private final KeyedDiff diff = new KeyedDiff();

        private NetStats() {
        }

        @Override
        public void emit(ServiceEmitter emitter) {
            Object[] ifaces = null;
            try {
                ifaces = SysMonitor.this.sigar.getNetInterfaceList();
            }
            catch (SigarException e) {
                log.error((Throwable)e, "Failed to get NetInterface list", new Object[0]);
            }
            if (ifaces != null) {
                log.debug("Found NetInterface list: [%s]", new Object[]{Joiner.on((String)", ").join(ifaces)});
                for (Object name : ifaces) {
                    NetInterfaceConfig netconf = null;
                    try {
                        netconf = SysMonitor.this.sigar.getNetInterfaceConfig((String)name);
                    }
                    catch (SigarException e) {
                        log.error((Throwable)e, "Failed to get NetInterfaceConfig[%s]", new Object[]{name});
                    }
                    if (netconf == null) continue;
                    if (!SysMonitor.this.netAddressBlacklist.contains(netconf.getAddress())) {
                        Map<String, Long> stats;
                        NetInterfaceStat netstat = null;
                        try {
                            netstat = SysMonitor.this.sigar.getNetInterfaceStat((String)name);
                        }
                        catch (SigarException e) {
                            log.error((Throwable)e, "Failed to get NetInterfaceStat[%s]", new Object[]{name});
                        }
                        if (netstat == null || (stats = this.diff.to((String)name, (Map<String, Long>)ImmutableMap.of((Object)"sys/net/read/size", (Object)netstat.getRxBytes(), (Object)"sys/net/write/size", (Object)netstat.getTxBytes()))) == null) continue;
                        ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder().setUser1(netconf.getName()).setUser2(netconf.getAddress()).setUser3(netconf.getHwaddr());
                        for (Map.Entry<String, Long> entry : stats.entrySet()) {
                            emitter.emit(builder.build(entry.getKey(), (Number)entry.getValue()));
                        }
                        continue;
                    }
                    log.debug("Not monitoring net stats for name[%s] with address[%s]", new Object[]{name, netconf.getAddress()});
                }
            }
        }
    }

    private class DiskStats
    implements Stats {
        private final KeyedDiff diff = new KeyedDiff();

        private DiskStats() {
        }

        @Override
        public void emit(ServiceEmitter emitter) {
            Object[] fss = null;
            try {
                fss = SysMonitor.this.sigar.getFileSystemList();
            }
            catch (SigarException e) {
                log.error((Throwable)e, "Failed to get FileSystem list", new Object[0]);
            }
            if (fss != null) {
                log.debug("Found FileSystem list: [%s]", new Object[]{Joiner.on((String)", ").join(fss)});
                for (Object fs : fss) {
                    String name = fs.getDevName();
                    if (SysMonitor.this.fsTypeWhitelist.contains(fs.getTypeName())) {
                        Map<String, Long> stats;
                        DiskUsage du = null;
                        try {
                            du = SysMonitor.this.sigar.getDiskUsage(name);
                        }
                        catch (SigarException e) {
                            log.error((Throwable)e, "Failed to get DiskUsage[%s]", new Object[]{name});
                        }
                        if (du == null || (stats = this.diff.to(name, (Map<String, Long>)ImmutableMap.of((Object)"sys/disk/read/size", (Object)du.getReadBytes(), (Object)"sys/disk/read/count", (Object)du.getReads(), (Object)"sys/disk/write/size", (Object)du.getWriteBytes(), (Object)"sys/disk/write/count", (Object)du.getWrites()))) == null) continue;
                        ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder().setUser1(fs.getDevName()).setUser2(fs.getDirName()).setUser3(fs.getTypeName()).setUser4(fs.getSysTypeName()).setUser5(fs.getOptions().split(","));
                        for (Map.Entry<String, Long> entry : stats.entrySet()) {
                            emitter.emit(builder.build(entry.getKey(), (Number)entry.getValue()));
                        }
                        continue;
                    }
                    log.debug("Not monitoring disk stats for name[%s] with typeName[%s]", new Object[]{name, fs.getTypeName()});
                }
            }
        }
    }

    private class FsStats
    implements Stats {
        private FsStats() {
        }

        @Override
        public void emit(ServiceEmitter emitter) {
            Object[] fss = null;
            try {
                fss = SysMonitor.this.sigar.getFileSystemList();
            }
            catch (SigarException e) {
                log.error((Throwable)e, "Failed to get FileSystem list", new Object[0]);
            }
            if (fss != null) {
                log.debug("Found FileSystem list: [%s]", new Object[]{Joiner.on((String)", ").join(fss)});
                for (Object fs : fss) {
                    String name = fs.getDirName();
                    if (SysMonitor.this.fsTypeWhitelist.contains(fs.getTypeName())) {
                        FileSystemUsage fsu = null;
                        try {
                            fsu = SysMonitor.this.sigar.getFileSystemUsage(name);
                        }
                        catch (SigarException e) {
                            log.error((Throwable)e, "Failed to get FileSystemUsage[%s]", new Object[]{name});
                        }
                        if (fsu == null) continue;
                        ImmutableMap stats = ImmutableMap.of((Object)"sys/fs/max", (Object)(fsu.getTotal() * 1024L), (Object)"sys/fs/used", (Object)(fsu.getUsed() * 1024L));
                        ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder().setUser1(fs.getDevName()).setUser2(fs.getDirName()).setUser3(fs.getTypeName()).setUser4(fs.getSysTypeName()).setUser5(fs.getOptions().split(","));
                        for (Map.Entry entry : stats.entrySet()) {
                            emitter.emit(builder.build((String)entry.getKey(), (Number)entry.getValue()));
                        }
                        continue;
                    }
                    log.debug("Not monitoring fs stats for name[%s] with typeName[%s]", new Object[]{name, fs.getTypeName()});
                }
            }
        }
    }

    private class DirStats
    implements Stats {
        private final String[] dirList;

        private DirStats(String[] dirList) {
            this.dirList = dirList;
        }

        @Override
        public void emit(ServiceEmitter emitter) {
            for (String dir : this.dirList) {
                DirUsage du = null;
                try {
                    du = SysMonitor.this.sigar.getDirUsage(dir);
                }
                catch (SigarException e) {
                    log.error("Failed to get DiskUsage for [%s] due to   [%s]", new Object[]{dir, e.getMessage()});
                }
                if (du == null) continue;
                ImmutableMap stats = ImmutableMap.of((Object)"sys/storage/used", (Object)du.getDiskUsage());
                ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder().setUser2(dir);
                for (Map.Entry entry : stats.entrySet()) {
                    emitter.emit(builder.build((String)entry.getKey(), (Number)entry.getValue()));
                }
            }
        }
    }

    private class SwapStats
    implements Stats {
        private long prevPageIn = 0L;
        private long prevPageOut = 0L;

        private SwapStats() {
            try {
                Swap swap = SysMonitor.this.sigar.getSwap();
                this.prevPageIn = swap.getPageIn();
                this.prevPageOut = swap.getPageOut();
            }
            catch (SigarException e) {
                log.error((Throwable)e, "Failed to get Swap", new Object[0]);
            }
        }

        @Override
        public void emit(ServiceEmitter emitter) {
            Swap swap = null;
            try {
                swap = SysMonitor.this.sigar.getSwap();
            }
            catch (SigarException e) {
                log.error((Throwable)e, "Failed to get Swap", new Object[0]);
            }
            if (swap != null) {
                long currPageIn = swap.getPageIn();
                long currPageOut = swap.getPageOut();
                ImmutableMap stats = ImmutableMap.of((Object)"sys/swap/pageIn", (Object)(currPageIn - this.prevPageIn), (Object)"sys/swap/pageOut", (Object)(currPageOut - this.prevPageOut), (Object)"sys/swap/max", (Object)swap.getTotal(), (Object)"sys/swap/free", (Object)swap.getFree());
                ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder();
                for (Map.Entry entry : stats.entrySet()) {
                    emitter.emit(builder.build((String)entry.getKey(), (Number)entry.getValue()));
                }
                this.prevPageIn = currPageIn;
                this.prevPageOut = currPageOut;
            }
        }
    }

    private class MemStats
    implements Stats {
        private MemStats() {
        }

        @Override
        public void emit(ServiceEmitter emitter) {
            Mem mem = null;
            try {
                mem = SysMonitor.this.sigar.getMem();
            }
            catch (SigarException e) {
                log.error((Throwable)e, "Failed to get Mem", new Object[0]);
            }
            if (mem != null) {
                ImmutableMap stats = ImmutableMap.of((Object)"sys/mem/max", (Object)mem.getTotal(), (Object)"sys/mem/used", (Object)mem.getUsed());
                ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder();
                for (Map.Entry entry : stats.entrySet()) {
                    emitter.emit(builder.build((String)entry.getKey(), (Number)entry.getValue()));
                }
            }
        }
    }

    private static interface Stats {
        public void emit(ServiceEmitter var1);
    }
}

