/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.metrics;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.metrics.Monitor;
import java.util.Arrays;
import java.util.List;

public abstract class CompoundMonitor
implements Monitor {
    private final List<Monitor> monitors;

    public CompoundMonitor(List<Monitor> monitors) {
        this.monitors = monitors;
    }

    public CompoundMonitor(Monitor ... monitors) {
        this(Arrays.asList(monitors));
    }

    @Override
    public void start() {
        for (Monitor monitor : this.monitors) {
            monitor.start();
        }
    }

    @Override
    public void stop() {
        for (Monitor monitor : this.monitors) {
            monitor.stop();
        }
    }

    @Override
    public boolean monitor(final ServiceEmitter emitter) {
        return this.shouldReschedule(Lists.transform(this.monitors, (Function)new Function<Monitor, Boolean>(){

            public Boolean apply(Monitor monitor) {
                return monitor.monitor(emitter);
            }
        }));
    }

    public abstract boolean shouldReschedule(List<Boolean> var1);
}

