/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.metrics;

import com.google.common.collect.Sets;
import com.metamx.common.ISE;
import com.metamx.common.concurrent.ScheduledExecutors;
import com.metamx.common.lifecycle.LifecycleStart;
import com.metamx.common.lifecycle.LifecycleStop;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.metrics.Monitor;
import com.metamx.metrics.MonitorSchedulerConfig;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import org.joda.time.Duration;

public class MonitorScheduler {
    private final MonitorSchedulerConfig config;
    private final ScheduledExecutorService exec;
    private final ServiceEmitter emitter;
    private final Set<Monitor> monitors;
    private final Object lock = new Object();
    private volatile boolean started = false;

    public MonitorScheduler(MonitorSchedulerConfig config, ScheduledExecutorService exec, ServiceEmitter emitter, List<Monitor> monitors) {
        this.config = config;
        this.exec = exec;
        this.emitter = emitter;
        this.monitors = Sets.newHashSet(monitors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            this.started = true;
            for (Monitor monitor : this.monitors) {
                this.startMonitor(monitor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMonitor(Monitor monitor) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                throw new ISE("addMonitor must be called after start", new Object[0]);
            }
            if (this.hasMonitor(monitor)) {
                throw new ISE("Monitor already monitoring: %s", new Object[]{monitor});
            }
            this.monitors.add(monitor);
            this.startMonitor(monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMonitor(Monitor monitor) {
        Object object = this.lock;
        synchronized (object) {
            this.monitors.remove(monitor);
            monitor.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            this.started = false;
            for (Monitor monitor : this.monitors) {
                this.removeMonitor(monitor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startMonitor(final Monitor monitor) {
        Object object = this.lock;
        synchronized (object) {
            monitor.start();
            ScheduledExecutors.scheduleAtFixedRate((ScheduledExecutorService)this.exec, (Duration)this.config.getEmitterPeriod(), (Callable)new Callable<ScheduledExecutors.Signal>(){

                @Override
                public ScheduledExecutors.Signal call() throws Exception {
                    if (monitor.monitor(MonitorScheduler.this.emitter) && MonitorScheduler.this.hasMonitor(monitor)) {
                        return ScheduledExecutors.Signal.REPEAT;
                    }
                    MonitorScheduler.this.removeMonitor(monitor);
                    return ScheduledExecutors.Signal.STOP;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasMonitor(Monitor monitor) {
        Object object = this.lock;
        synchronized (object) {
            return this.monitors.contains(monitor);
        }
    }
}

