/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.metrics;

import com.metamx.common.concurrent.ScheduledExecutors;
import com.metamx.common.lifecycle.LifecycleStart;
import com.metamx.common.lifecycle.LifecycleStop;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.metrics.Monitor;
import com.metamx.metrics.MonitorSchedulerConfig;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import org.joda.time.Duration;

public class MonitorScheduler {
    private final MonitorSchedulerConfig config;
    private final ScheduledExecutorService exec;
    private final ServiceEmitter emitter;
    private final List<Monitor> monitors;
    private volatile boolean started = false;

    public MonitorScheduler(MonitorSchedulerConfig config, ScheduledExecutorService exec, ServiceEmitter emitter, List<Monitor> monitors) {
        this.config = config;
        this.exec = exec;
        this.emitter = emitter;
        this.monitors = monitors;
    }

    @LifecycleStart
    public synchronized void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        for (final Monitor monitor : this.monitors) {
            monitor.start();
            ScheduledExecutors.scheduleAtFixedRate((ScheduledExecutorService)this.exec, (Duration)this.config.getEmitterPeriod(), (Callable)new Callable<ScheduledExecutors.Signal>(){

                @Override
                public ScheduledExecutors.Signal call() throws Exception {
                    return monitor.monitor(MonitorScheduler.this.emitter) ? ScheduledExecutors.Signal.REPEAT : ScheduledExecutors.Signal.STOP;
                }
            });
        }
    }

    @LifecycleStop
    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        for (Monitor monitor : this.monitors) {
            monitor.stop();
        }
    }
}

