/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.metrics;

import com.google.common.collect.ImmutableMap;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.emitter.service.ServiceMetricEvent;
import com.metamx.metrics.AbstractMonitor;
import com.metamx.metrics.KeyedDiff;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.Map;

public class JvmMonitor
extends AbstractMonitor {
    private final KeyedDiff gcDiff = new KeyedDiff();

    @Override
    public boolean doMonitor(ServiceEmitter emitter) {
        ServiceMetricEvent.Builder builder;
        MemoryUsage usage;
        String kind;
        ImmutableMap usages = ImmutableMap.of((Object)"heap", (Object)ManagementFactory.getMemoryMXBean().getHeapMemoryUsage(), (Object)"nonheap", (Object)ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage());
        for (Map.Entry entry : usages.entrySet()) {
            kind = (String)entry.getKey();
            usage = (MemoryUsage)entry.getValue();
            builder = new ServiceMetricEvent.Builder().setUser1(kind);
            emitter.emit(builder.build("jvm/mem/max", (Number)usage.getMax()));
            emitter.emit(builder.build("jvm/mem/committed", (Number)usage.getCommitted()));
            emitter.emit(builder.build("jvm/mem/used", (Number)usage.getUsed()));
            emitter.emit(builder.build("jvm/mem/init", (Number)usage.getInit()));
        }
        for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
            kind = pool.getType() == MemoryType.HEAP ? "heap" : "nonheap";
            usage = pool.getUsage();
            builder = new ServiceMetricEvent.Builder().setUser1(kind).setUser2(pool.getName());
            emitter.emit(builder.build("jvm/pool/max", (Number)usage.getMax()));
            emitter.emit(builder.build("jvm/pool/committed", (Number)usage.getCommitted()));
            emitter.emit(builder.build("jvm/pool/used", (Number)usage.getUsed()));
            emitter.emit(builder.build("jvm/pool/init", (Number)usage.getInit()));
        }
        for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
            Map<String, Long> diff = this.gcDiff.to(gc.getName(), (Map<String, Long>)ImmutableMap.of((Object)"jvm/gc/time", (Object)gc.getCollectionTime(), (Object)"jvm/gc/count", (Object)gc.getCollectionCount()));
            if (diff == null) continue;
            ServiceMetricEvent.Builder builder2 = new ServiceMetricEvent.Builder().setUser1(gc.getName());
            for (Map.Entry<String, Long> entry : diff.entrySet()) {
                emitter.emit(builder2.build(entry.getKey(), (Number)entry.getValue()));
            }
        }
        return true;
    }
}

