/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.metrics;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.metamx.common.logger.Logger;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.emitter.service.ServiceMetricEvent;
import com.metamx.metrics.FeedDefiningMonitor;
import com.metamx.metrics.KeyedDiff;
import com.metamx.metrics.MonitorUtils;
import com.metamx.metrics.SigarUtil;
import java.util.Map;
import org.hyperic.sigar.ProcCpu;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public class JvmCpuMonitor
extends FeedDefiningMonitor {
    private static final Logger log = new Logger(JvmCpuMonitor.class);
    private final Sigar sigar = SigarUtil.getSigar();
    private final long currentProcessId = this.sigar.getPid();
    private final KeyedDiff diff = new KeyedDiff();
    private Map<String, String[]> dimensions;

    public JvmCpuMonitor() {
        this((Map<String, String[]>)ImmutableMap.of());
    }

    public JvmCpuMonitor(Map<String, String[]> dimensions) {
        this(dimensions, "metrics");
    }

    public JvmCpuMonitor(Map<String, String[]> dimensions, String feed) {
        super(feed);
        Preconditions.checkNotNull(dimensions);
        this.dimensions = ImmutableMap.copyOf(dimensions);
    }

    @Override
    public boolean doMonitor(ServiceEmitter emitter) {
        try {
            ProcCpu procCpu = this.sigar.getProcCpu(this.currentProcessId);
            ServiceMetricEvent.Builder builder = this.builder();
            MonitorUtils.addDimensionsToBuilder(builder, this.dimensions);
            Map<String, Long> procDiff = this.diff.to("proc/cpu", (Map<String, Long>)ImmutableMap.of((Object)"jvm/cpu/total", (Object)procCpu.getTotal(), (Object)"jvm/cpu/sys", (Object)procCpu.getSys(), (Object)"jvm/cpu/user", (Object)procCpu.getUser()));
            if (procDiff != null) {
                for (Map.Entry<String, Long> entry : procDiff.entrySet()) {
                    emitter.emit(builder.build(entry.getKey(), entry.getValue()));
                }
            }
            emitter.emit(builder.build("jvm/cpu/percent", procCpu.getPercent()));
        }
        catch (SigarException e) {
            log.error(e, "Failed to get ProcCpu", new Object[0]);
        }
        return true;
    }
}

