/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.http.client.pool;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.metamx.common.logger.Logger;
import com.metamx.http.client.pool.ResourceContainer;
import com.metamx.http.client.pool.ResourceFactory;
import com.metamx.http.client.pool.ResourcePoolConfig;
import java.io.Closeable;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;

public class ResourcePool<K, V>
implements Closeable {
    private static final Logger log = new Logger(ResourcePool.class);
    private final LoadingCache<K, ImmediateCreationResourceHolder<K, V>> pool;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public ResourcePool(final ResourceFactory<K, V> factory, final ResourcePoolConfig config) {
        this.pool = CacheBuilder.newBuilder().build(new CacheLoader<K, ImmediateCreationResourceHolder<K, V>>(){

            public ImmediateCreationResourceHolder<K, V> load(K input) throws Exception {
                return new ImmediateCreationResourceHolder(config.getMaxPerKey(), input, factory);
            }
        });
    }

    public ResourceContainer<V> take(final K key) {
        ImmediateCreationResourceHolder holder;
        if (this.closed.get()) {
            log.error(String.format("take(%s) called even though I'm closed.", key), new Object[0]);
            return null;
        }
        try {
            holder = (ImmediateCreationResourceHolder)this.pool.get(key);
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e);
        }
        final Object value = holder.get();
        return new ResourceContainer<V>(){
            private final AtomicBoolean returned = new AtomicBoolean(false);

            @Override
            public V get() {
                Preconditions.checkState((!this.returned.get() ? 1 : 0) != 0, (String)"Resource for key[%s] has been returned, cannot get().", (Object[])new Object[]{key});
                return value;
            }

            @Override
            public void returnResource() {
                if (this.returned.getAndSet(true)) {
                    log.warn(String.format("Resource at key[%s] was returned multiple times?", key), new Object[0]);
                } else {
                    holder.giveBack(value);
                }
            }

            protected void finalize() throws Throwable {
                if (!this.returned.get()) {
                    log.warn(String.format("Resource[%s] at key[%s] was not returned before Container was finalized, potential resource leak.", value, key), new Object[0]);
                    this.returnResource();
                }
                super.finalize();
            }
        };
    }

    @Override
    public void close() {
        this.closed.set(true);
        ConcurrentMap mapView = this.pool.asMap();
        for (Object k : ImmutableSet.copyOf(mapView.keySet())) {
            ((ImmediateCreationResourceHolder)mapView.remove(k)).close();
        }
    }

    private static class ImmediateCreationResourceHolder<K, V> {
        private final int maxSize;
        private final K key;
        private final ResourceFactory<K, V> factory;
        private final LinkedList<V> objectList;
        private int deficit = 0;
        private boolean closed = false;

        private ImmediateCreationResourceHolder(int maxSize, K key, ResourceFactory<K, V> factory) {
            this.maxSize = maxSize;
            this.key = key;
            this.factory = factory;
            this.objectList = new LinkedList();
            for (int i = 0; i < maxSize; ++i) {
                this.objectList.addLast(Preconditions.checkNotNull(factory.generate(key), (Object)"factory.generate(key)"));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V get() {
            V retVal;
            V poolVal;
            ImmediateCreationResourceHolder immediateCreationResourceHolder = this;
            synchronized (immediateCreationResourceHolder) {
                while (!this.closed && this.objectList.size() == 0 && this.deficit == 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                        return null;
                    }
                }
                if (this.closed) {
                    log.info(String.format("get() called even though I'm closed. key[%s]", this.key), new Object[0]);
                    return null;
                }
                if (!this.objectList.isEmpty()) {
                    poolVal = this.objectList.removeFirst();
                } else if (this.deficit > 0) {
                    --this.deficit;
                    poolVal = null;
                } else {
                    throw new IllegalStateException("WTF?! No objects left, and no object deficit. This is probably a bug.");
                }
            }
            try {
                if (poolVal != null && this.factory.isGood(poolVal)) {
                    retVal = poolVal;
                } else {
                    if (poolVal != null) {
                        this.factory.close(poolVal);
                    }
                    retVal = this.factory.generate(this.key);
                }
            }
            catch (Throwable e) {
                ImmediateCreationResourceHolder immediateCreationResourceHolder2 = this;
                synchronized (immediateCreationResourceHolder2) {
                    ++this.deficit;
                    this.notifyAll();
                }
                throw Throwables.propagate((Throwable)e);
            }
            return retVal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void giveBack(V object) {
            Preconditions.checkNotNull(object, (Object)"object");
            ImmediateCreationResourceHolder immediateCreationResourceHolder = this;
            synchronized (immediateCreationResourceHolder) {
                if (this.closed) {
                    log.info(String.format("giveBack called after being closed. key[%s]", this.key), new Object[0]);
                    this.factory.close(object);
                    return;
                }
                if (this.objectList.size() >= this.maxSize) {
                    if (this.objectList.contains(object)) {
                        log.warn(String.format("Returning object[%s] at key[%s] that has already been returned!? Skipping", object, this.key), new Exception("Exception for stacktrace"));
                    } else {
                        log.warn(String.format("Returning object[%s] at key[%s] even though we already have all that we can hold[%s]!? Skipping", object, this.key, this.objectList), new Exception("Exception for stacktrace"));
                    }
                    return;
                }
                this.objectList.addLast(object);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            ImmediateCreationResourceHolder immediateCreationResourceHolder = this;
            synchronized (immediateCreationResourceHolder) {
                this.closed = true;
                while (!this.objectList.isEmpty()) {
                    this.factory.close(this.objectList.removeFirst());
                }
                this.notifyAll();
            }
        }
    }
}

