/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.emitter.core;

public enum BatchingStrategy {
    ARRAY{

        @Override
        public int batchStartLength() {
            return 1;
        }

        @Override
        public int separatorLength() {
            return 1;
        }

        @Override
        public int batchEndLength() {
            return 2;
        }

        @Override
        public int writeBatchStart(byte[] buffer) {
            buffer[0] = 91;
            return this.batchStartLength();
        }

        @Override
        public int writeMessageSeparator(byte[] buffer, int bufferOffset) {
            buffer[bufferOffset] = 44;
            return bufferOffset + this.separatorLength();
        }

        @Override
        public int writeBatchEnd(byte[] buffer, int bufferOffset) {
            buffer[bufferOffset] = 93;
            buffer[bufferOffset + 1] = 10;
            return bufferOffset + this.batchEndLength();
        }
    }
    ,
    NEWLINES{

        @Override
        public int batchStartLength() {
            return 0;
        }

        @Override
        public int separatorLength() {
            return 1;
        }

        @Override
        public int batchEndLength() {
            return 1;
        }

        @Override
        public int writeBatchStart(byte[] buffer) {
            return this.batchStartLength();
        }

        @Override
        public int writeMessageSeparator(byte[] buffer, int bufferOffset) {
            buffer[bufferOffset] = 10;
            return bufferOffset + this.separatorLength();
        }

        @Override
        public int writeBatchEnd(byte[] buffer, int bufferOffset) {
            return this.writeMessageSeparator(buffer, bufferOffset);
        }
    }
    ,
    ONLY_EVENTS{

        @Override
        public int batchStartLength() {
            return 0;
        }

        @Override
        public int separatorLength() {
            return 0;
        }

        @Override
        public int batchEndLength() {
            return 0;
        }

        @Override
        public int writeBatchStart(byte[] buffer) {
            return 0;
        }

        @Override
        public int writeMessageSeparator(byte[] buffer, int bufferOffset) {
            return bufferOffset;
        }

        @Override
        public int writeBatchEnd(byte[] buffer, int bufferOffset) {
            return bufferOffset;
        }
    };


    public abstract int batchStartLength();

    public abstract int separatorLength();

    public abstract int batchEndLength();

    public abstract int writeBatchStart(byte[] var1);

    public abstract int writeMessageSeparator(byte[] var1, int var2);

    public abstract int writeBatchEnd(byte[] var1, int var2);
}

