/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.http2.parser;

import java.nio.ByteBuffer;
import wiremock.org.eclipse.jetty.http2.parser.BodyParser;
import wiremock.org.eclipse.jetty.http2.parser.HeaderParser;
import wiremock.org.eclipse.jetty.http2.parser.Parser;

public class UnknownBodyParser
extends BodyParser {
    private int cursor;

    public UnknownBodyParser(HeaderParser headerParser, Parser.Listener listener) {
        super(headerParser, listener);
    }

    @Override
    public boolean parse(ByteBuffer buffer) {
        int length = this.cursor == 0 ? this.getBodyLength() : this.cursor;
        this.cursor = this.consume(buffer, length);
        return this.cursor == 0;
    }

    private int consume(ByteBuffer buffer, int length) {
        int remaining = buffer.remaining();
        if (remaining >= length) {
            buffer.position(buffer.position() + length);
            return 0;
        }
        buffer.position(buffer.limit());
        return length - remaining;
    }
}

