/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.Foreign;
import com.kenai.jffi.Type;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Aggregate
extends Type {
    private final int type;
    private final int size;
    private final int align;
    private final long handle;
    private final Foreign foreign;

    Aggregate(Foreign foreign, long handle) {
        if (handle == 0L) {
            throw new NullPointerException("Invalid ffi_type handle");
        }
        this.foreign = foreign;
        this.handle = handle;
        this.type = foreign.getTypeType(handle);
        this.size = foreign.getTypeSize(handle);
        this.align = foreign.getTypeAlign(handle);
    }

    final long handle() {
        return this.handle;
    }

    public final int type() {
        return this.type;
    }

    public final int size() {
        return this.size;
    }

    public final int alignment() {
        return this.align;
    }

    public final synchronized void dispose() {
    }

    protected void finalize() throws Throwable {
        try {
            this.foreign.freeAggregate(this.handle);
        }
        catch (Throwable t) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Exception when freeing FFI aggregate: %s", t.getLocalizedMessage());
        }
        finally {
            super.finalize();
        }
    }
}

