/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.CallInfo;
import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Foreign;
import com.kenai.jffi.HeapInvocationBuffer;
import com.kenai.jffi.Type;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Function
implements CallInfo {
    private final long contextAddress;
    private final long functionAddress;
    private final int parameterCount;
    private final int rawParameterSize;
    private final Type returnType;
    private final Type[] paramTypes;
    private final int[] parameterOffsets;
    private volatile boolean disposed = false;
    private final Foreign foreign = Foreign.getInstance();

    public Function(long address, Type returnType, Type ... paramTypes) {
        this(address, returnType, paramTypes, CallingConvention.DEFAULT, true);
    }

    public Function(long address, Type returnType, Type[] paramTypes, CallingConvention convention) {
        this(address, returnType, paramTypes, convention, true);
    }

    public Function(long address, Type returnType, Type[] paramTypes, CallingConvention convention, boolean saveErrno) {
        this.functionAddress = address;
        int flags = (!saveErrno ? 2 : 0) | (convention == CallingConvention.STDCALL ? 1 : 0);
        long h = this.foreign.newFunction(address, returnType.handle(), Type.nativeHandles(paramTypes), flags);
        if (h == 0L) {
            throw new RuntimeException("Failed to create native function");
        }
        this.contextAddress = h;
        this.returnType = returnType;
        this.paramTypes = (Type[])paramTypes.clone();
        this.parameterCount = paramTypes.length;
        this.rawParameterSize = this.foreign.getFunctionRawParameterSize(h);
        this.parameterOffsets = new int[this.parameterCount];
        int rawOffset = 0;
        for (int i = 0; i < this.parameterCount; ++i) {
            this.parameterOffsets[i] = rawOffset += HeapInvocationBuffer.FFI_ALIGN(paramTypes[i].size(), HeapInvocationBuffer.FFI_SIZEOF_ARG);
        }
    }

    public final int getParameterCount() {
        return this.parameterCount;
    }

    public final int getRawParameterSize() {
        return this.rawParameterSize;
    }

    final long getContextAddress() {
        return this.contextAddress;
    }

    public final long getFunctionAddress() {
        return this.functionAddress;
    }

    public final Type getReturnType() {
        return this.returnType;
    }

    public final Type getParameterType(int index) {
        return this.paramTypes[index];
    }

    final int getParameterOffset(int index) {
        return this.parameterOffsets[index];
    }

    public final synchronized void dispose() {
        if (this.disposed) {
            throw new RuntimeException("function already freed");
        }
        this.foreign.freeFunction(this.contextAddress);
        this.disposed = true;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.contextAddress != 0L && !this.disposed) {
                this.foreign.freeFunction(this.contextAddress);
            }
        }
        catch (Throwable t) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Exception when freeing function context: %s", t.getLocalizedMessage());
        }
        finally {
            super.finalize();
        }
    }
}

