/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol;

import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.utils.UrlUtils;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.ListenableFilter;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.ProtocolServer;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;

public class ProtocolFilterWrapper
implements Protocol {
    private final Protocol protocol;

    public ProtocolFilterWrapper(Protocol protocol) {
        if (protocol == null) {
            throw new IllegalArgumentException("protocol == null");
        }
        this.protocol = protocol;
    }

    private static <T> Invoker<T> buildInvokerChain(final Invoker<T> invoker, String key, String group) {
        Invoker last = invoker;
        List<Filter> filters = ExtensionLoader.getExtensionLoader(Filter.class).getActivateExtension(invoker.getUrl(), key, group);
        if (!filters.isEmpty()) {
            for (int i = filters.size() - 1; i >= 0; --i) {
                final Filter filter = filters.get(i);
                final Invoker next = last;
                last = new Invoker<T>(){

                    @Override
                    public Class<T> getInterface() {
                        return invoker.getInterface();
                    }

                    @Override
                    public URL getUrl() {
                        return invoker.getUrl();
                    }

                    @Override
                    public boolean isAvailable() {
                        return invoker.isAvailable();
                    }

                    @Override
                    public Result invoke(Invocation invocation) throws RpcException {
                        Result asyncResult;
                        try {
                            asyncResult = filter.invoke(next, invocation);
                        }
                        catch (Exception e) {
                            if (filter instanceof ListenableFilter) {
                                Filter.Listener listener = ((ListenableFilter)filter).listener();
                                if (listener != null) {
                                    listener.onError(e, invoker, invocation);
                                }
                            } else if (filter instanceof Filter.Listener) {
                                Filter.Listener listener = (Filter.Listener)((Object)filter);
                                listener.onError(e, invoker, invocation);
                            }
                            throw e;
                        }
                        return asyncResult.whenCompleteWithContext((r, t) -> {
                            if (filter instanceof ListenableFilter) {
                                Filter.Listener listener = ((ListenableFilter)filter).listener();
                                if (listener != null) {
                                    if (t == null) {
                                        listener.onMessage((Result)r, invoker, invocation);
                                    } else {
                                        listener.onError((Throwable)t, invoker, invocation);
                                    }
                                }
                            } else if (filter instanceof Filter.Listener) {
                                Filter.Listener listener = (Filter.Listener)((Object)filter);
                                if (t == null) {
                                    listener.onMessage((Result)r, invoker, invocation);
                                } else {
                                    listener.onError((Throwable)t, invoker, invocation);
                                }
                            } else {
                                filter.onResponse((Result)r, invoker, invocation);
                            }
                        });
                    }

                    @Override
                    public void destroy() {
                        invoker.destroy();
                    }

                    public String toString() {
                        return invoker.toString();
                    }
                };
            }
        }
        return last;
    }

    @Override
    public int getDefaultPort() {
        return this.protocol.getDefaultPort();
    }

    @Override
    public <T> Exporter<T> export(Invoker<T> invoker) throws RpcException {
        if (UrlUtils.isRegistry(invoker.getUrl())) {
            return this.protocol.export(invoker);
        }
        return this.protocol.export(ProtocolFilterWrapper.buildInvokerChain(invoker, "service.filter", "provider"));
    }

    @Override
    public <T> Invoker<T> refer(Class<T> type, URL url) throws RpcException {
        if (UrlUtils.isRegistry(url)) {
            return this.protocol.refer(type, url);
        }
        return ProtocolFilterWrapper.buildInvokerChain(this.protocol.refer(type, url), "reference.filter", "consumer");
    }

    @Override
    public void destroy() {
        this.protocol.destroy();
    }

    @Override
    public List<ProtocolServer> getServers() {
        return this.protocol.getServers();
    }
}

