/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.model;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.ServiceDescriptor;
import org.apache.dubbo.common.URL;

public class ServiceMetadata
extends ServiceDescriptor {
    private String defaultGroup;
    private Class<?> serviceType;
    private Object target;
    private final Map<String, Object> attachments = new ConcurrentHashMap<String, Object>();
    private final Map<String, Object> attributeMap = new ConcurrentHashMap<String, Object>();

    public ServiceMetadata(String serviceInterfaceName, String group, String version, Class<?> serviceType) {
        this.serviceInterfaceName = serviceInterfaceName;
        this.defaultGroup = group;
        this.group = group;
        this.version = version;
        this.serviceKey = URL.buildKey(serviceInterfaceName, group, version);
        this.serviceType = serviceType;
    }

    public ServiceMetadata() {
    }

    @Override
    public String getServiceKey() {
        return this.serviceKey;
    }

    public Map<String, Object> getAttachments() {
        return this.attachments;
    }

    public Map<String, Object> getAttributeMap() {
        return this.attributeMap;
    }

    public Object getAttribute(String key) {
        return this.attributeMap.get(key);
    }

    public void addAttribute(String key, Object value) {
        this.attributeMap.put(key, value);
    }

    public void addAttachment(String key, Object value) {
        this.attributeMap.put(key, value);
    }

    public Class<?> getServiceType() {
        return this.serviceType;
    }

    public String getDefaultGroup() {
        return this.defaultGroup;
    }

    public void setDefaultGroup(String defaultGroup) {
        this.defaultGroup = defaultGroup;
    }

    public void setServiceType(Class<?> serviceType) {
        this.serviceType = serviceType;
    }

    public Object getTarget() {
        return this.target;
    }

    public void setTarget(Object target) {
        this.target = target;
    }
}

