/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.configurator.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.cluster.configurator.parser.model.ConfigItem;
import org.apache.dubbo.rpc.cluster.configurator.parser.model.ConfiguratorConfig;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.Constructor;

public class ConfigParser {
    public static List<URL> parseConfigurators(String rawConfig) {
        ArrayList<URL> urls = new ArrayList<URL>();
        ConfiguratorConfig configuratorConfig = (ConfiguratorConfig)ConfigParser.parseObject(rawConfig);
        String scope = configuratorConfig.getScope();
        List<ConfigItem> items = configuratorConfig.getConfigs();
        if ("application".equals(scope)) {
            items.forEach(item -> urls.addAll(ConfigParser.appItemToUrls(item, configuratorConfig)));
        } else {
            items.forEach(item -> urls.addAll(ConfigParser.serviceItemToUrls(item, configuratorConfig)));
        }
        return urls;
    }

    private static <T> T parseObject(String rawConfig) {
        Constructor constructor = new Constructor(ConfiguratorConfig.class);
        TypeDescription itemDescription = new TypeDescription(ConfiguratorConfig.class);
        itemDescription.addPropertyParameters("items", ConfigItem.class);
        constructor.addTypeDescription(itemDescription);
        Yaml yaml = new Yaml(constructor);
        return yaml.load(rawConfig);
    }

    private static List<URL> serviceItemToUrls(ConfigItem item, ConfiguratorConfig config) {
        ArrayList<URL> urls = new ArrayList<URL>();
        List<String> addresses = ConfigParser.parseAddresses(item);
        addresses.forEach(addr -> {
            StringBuilder urlBuilder = new StringBuilder();
            urlBuilder.append("override://").append((String)addr).append("/");
            urlBuilder.append(ConfigParser.appendService(config.getKey()));
            urlBuilder.append(ConfigParser.toParameterString(item));
            ConfigParser.parseEnabled(item, config, urlBuilder);
            urlBuilder.append("&category=").append("dynamicconfigurators");
            urlBuilder.append("&configVersion=").append(config.getConfigVersion());
            List<String> apps = item.getApplications();
            if (apps != null && apps.size() > 0) {
                apps.forEach(app -> urls.add(URL.valueOf(urlBuilder.append("&application=").append((String)app).toString())));
            } else {
                urls.add(URL.valueOf(urlBuilder.toString()));
            }
        });
        return urls;
    }

    private static List<URL> appItemToUrls(ConfigItem item, ConfiguratorConfig config) {
        ArrayList<URL> urls = new ArrayList<URL>();
        List<String> addresses = ConfigParser.parseAddresses(item);
        for (String addr : addresses) {
            StringBuilder urlBuilder = new StringBuilder();
            urlBuilder.append("override://").append(addr).append("/");
            List<String> services = item.getServices();
            if (services == null) {
                services = new ArrayList<String>();
            }
            if (services.size() == 0) {
                services.add("*");
            }
            for (String s : services) {
                urlBuilder.append(ConfigParser.appendService(s));
                urlBuilder.append(ConfigParser.toParameterString(item));
                urlBuilder.append("&application=").append(config.getKey());
                ConfigParser.parseEnabled(item, config, urlBuilder);
                urlBuilder.append("&category=").append("appdynamicconfigurators");
                urlBuilder.append("&configVersion=").append(config.getConfigVersion());
                urls.add(URL.valueOf(urlBuilder.toString()));
            }
        }
        return urls;
    }

    private static String toParameterString(ConfigItem item) {
        Map<String, String> parameters;
        StringBuilder sb = new StringBuilder();
        sb.append("category=");
        sb.append("dynamicconfigurators");
        if (item.getSide() != null) {
            sb.append("&side=");
            sb.append(item.getSide());
        }
        if (CollectionUtils.isEmptyMap(parameters = item.getParameters())) {
            throw new IllegalStateException("Invalid configurator rule, please specify at least one parameter you want to change in the rule.");
        }
        parameters.forEach((k, v) -> {
            sb.append("&");
            sb.append((String)k);
            sb.append("=");
            sb.append((String)v);
        });
        if (CollectionUtils.isNotEmpty(item.getProviderAddresses())) {
            sb.append("&");
            sb.append("providerAddresses");
            sb.append("=");
            sb.append(CollectionUtils.join(item.getProviderAddresses(), ","));
        }
        return sb.toString();
    }

    private static String appendService(String serviceKey) {
        int j;
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isEmpty(serviceKey)) {
            throw new IllegalStateException("service field in configuration is null.");
        }
        String interfaceName = serviceKey;
        int i = interfaceName.indexOf("/");
        if (i > 0) {
            sb.append("group=");
            sb.append(interfaceName, 0, i);
            sb.append("&");
            interfaceName = interfaceName.substring(i + 1);
        }
        if ((j = interfaceName.indexOf(":")) > 0) {
            sb.append("version=");
            sb.append(interfaceName.substring(j + 1));
            sb.append("&");
            interfaceName = interfaceName.substring(0, j);
        }
        sb.insert(0, interfaceName + "?");
        return sb.toString();
    }

    private static void parseEnabled(ConfigItem item, ConfiguratorConfig config, StringBuilder urlBuilder) {
        urlBuilder.append("&enabled=");
        if (item.getType() == null || "general".equals(item.getType())) {
            urlBuilder.append(config.getEnabled());
        } else {
            urlBuilder.append(item.getEnabled());
        }
    }

    private static List<String> parseAddresses(ConfigItem item) {
        List<String> addresses = item.getAddresses();
        if (addresses == null) {
            addresses = new ArrayList<String>();
        }
        if (addresses.size() == 0) {
            addresses.add("0.0.0.0");
        }
        return addresses;
    }
}

