/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.URLBuilder;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.function.ThrowableAction;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.metadata.ServiceNameMapping;
import org.apache.dubbo.metadata.WritableMetadataService;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.client.EventPublishingServiceDiscovery;
import org.apache.dubbo.registry.client.ServiceDiscovery;
import org.apache.dubbo.registry.client.ServiceDiscoveryFactory;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.event.ServiceInstancesChangedEvent;
import org.apache.dubbo.registry.client.event.listener.ServiceInstancesChangedListener;
import org.apache.dubbo.registry.client.metadata.ServiceInstanceMetadataUtils;
import org.apache.dubbo.registry.client.metadata.SubscribedURLsSynthesizer;
import org.apache.dubbo.registry.client.metadata.proxy.MetadataServiceProxyFactory;
import org.apache.dubbo.registry.client.selector.ServiceInstanceSelector;
import org.apache.dubbo.registry.support.FailbackRegistry;

public class ServiceDiscoveryRegistry
extends FailbackRegistry {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ServiceDiscovery serviceDiscovery;
    private final Set<String> subscribedServices;
    private final ServiceNameMapping serviceNameMapping;
    private final WritableMetadataService writableMetadataService;
    private final Set<String> registeredListeners = new LinkedHashSet<String>();
    private final List<SubscribedURLsSynthesizer> subscribedURLsSynthesizers;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<String, Map<String, List<URL>>> serviceRevisionExportedURLsCache = new LinkedHashMap<String, Map<String, List<URL>>>();

    public ServiceDiscoveryRegistry(URL registryURL) {
        super(registryURL);
        this.serviceDiscovery = this.createServiceDiscovery(registryURL);
        this.subscribedServices = ServiceDiscoveryRegistry.parseServices(registryURL.getParameter("subscribed-services"));
        this.serviceNameMapping = ServiceNameMapping.getDefaultExtension();
        String metadataStorageType = ServiceInstanceMetadataUtils.getMetadataStorageType(registryURL);
        this.writableMetadataService = WritableMetadataService.getExtension(metadataStorageType);
        this.subscribedURLsSynthesizers = this.initSubscribedURLsSynthesizers();
    }

    public ServiceDiscovery getServiceDiscovery() {
        return this.serviceDiscovery;
    }

    public static Set<String> getSubscribedServices(URL registryURL) {
        String subscribedServiceNames = registryURL.getParameter("subscribed-services");
        return StringUtils.isBlank(subscribedServiceNames) ? Collections.emptySet() : Collections.unmodifiableSet(Stream.of(subscribedServiceNames.split(",")).map(String::trim).filter(StringUtils::isNotEmpty).collect(Collectors.toSet()));
    }

    protected ServiceDiscovery createServiceDiscovery(URL registryURL) {
        ServiceDiscovery originalServiceDiscovery = this.getServiceDiscovery(registryURL);
        ServiceDiscovery serviceDiscovery = this.enhanceEventPublishing(originalServiceDiscovery);
        ThrowableAction.execute(() -> serviceDiscovery.initialize(registryURL.addParameter("interface", ServiceDiscovery.class.getName()).removeParameter("registry-type")));
        return serviceDiscovery;
    }

    private List<SubscribedURLsSynthesizer> initSubscribedURLsSynthesizers() {
        ExtensionLoader<SubscribedURLsSynthesizer> loader = ExtensionLoader.getExtensionLoader(SubscribedURLsSynthesizer.class);
        return Collections.unmodifiableList(new ArrayList<SubscribedURLsSynthesizer>(loader.getSupportedExtensionInstances()));
    }

    private ServiceDiscovery getServiceDiscovery(URL registryURL) {
        ServiceDiscoveryFactory factory = ServiceDiscoveryFactory.getExtension(registryURL);
        return factory.getServiceDiscovery(registryURL);
    }

    private ServiceDiscovery enhanceEventPublishing(ServiceDiscovery original) {
        return new EventPublishingServiceDiscovery(original);
    }

    protected boolean shouldRegister(URL providerURL) {
        String side = providerURL.getParameter("side");
        boolean should = "provider".equals(side);
        if (!should && this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("The URL[%s] should not be registered.", providerURL.toString()));
        }
        return should;
    }

    protected boolean shouldSubscribe(URL subscribedURL) {
        return !this.shouldRegister(subscribedURL);
    }

    @Override
    public final void register(URL url) {
        if (!this.shouldRegister(url)) {
            return;
        }
        super.register(url);
    }

    @Override
    public void doRegister(URL url) {
        if (this.writableMetadataService.exportURL(url)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(String.format("The URL[%s] registered successfully.", url.toString()));
            }
        } else if (this.logger.isWarnEnabled()) {
            this.logger.info(String.format("The URL[%s] has been registered.", url.toString()));
        }
    }

    @Override
    public final void unregister(URL url) {
        if (!this.shouldRegister(url)) {
            return;
        }
        super.unregister(url);
    }

    @Override
    public void doUnregister(URL url) {
        if (this.writableMetadataService.unexportURL(url)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(String.format("The URL[%s] deregistered successfully.", url.toString()));
            }
        } else if (this.logger.isWarnEnabled()) {
            this.logger.info(String.format("The URL[%s] has been deregistered.", url.toString()));
        }
    }

    @Override
    public final void subscribe(URL url, NotifyListener listener) {
        if (!this.shouldSubscribe(url)) {
            return;
        }
        super.subscribe(url, listener);
    }

    @Override
    public void doSubscribe(URL url, NotifyListener listener) {
        this.subscribeURLs(url, listener);
    }

    @Override
    public final void unsubscribe(URL url, NotifyListener listener) {
        if (!this.shouldSubscribe(url)) {
            return;
        }
        super.unsubscribe(url, listener);
    }

    @Override
    public void doUnsubscribe(URL url, NotifyListener listener) {
        this.writableMetadataService.unsubscribeURL(url);
    }

    @Override
    public boolean isAvailable() {
        return !this.serviceDiscovery.getServices().isEmpty();
    }

    @Override
    public void destroy() {
        super.destroy();
        ThrowableAction.execute(() -> this.serviceDiscovery.destroy());
    }

    protected void subscribeURLs(URL url, NotifyListener listener) {
        this.writableMetadataService.subscribeURL(url);
        Set<String> serviceNames = this.getServices(url);
        if (CollectionUtils.isEmpty(serviceNames)) {
            throw new IllegalStateException("Should has at least one way to know which services this interface belongs to, subscription url: " + url);
        }
        serviceNames.forEach(serviceName -> this.subscribeURLs(url, listener, (String)serviceName));
    }

    protected void subscribeURLs(final URL url, final NotifyListener listener, String serviceName) {
        List<ServiceInstance> serviceInstances = this.serviceDiscovery.getInstances(serviceName);
        this.subscribeURLs(url, listener, serviceName, serviceInstances);
        this.registerServiceInstancesChangedListener(url, new ServiceInstancesChangedListener(serviceName){

            @Override
            public void onEvent(ServiceInstancesChangedEvent event) {
                ServiceDiscoveryRegistry.this.subscribeURLs(url, listener, event.getServiceName(), new ArrayList<ServiceInstance>(event.getServiceInstances()));
            }
        });
    }

    private void registerServiceInstancesChangedListener(URL url, ServiceInstancesChangedListener listener) {
        String listenerId = this.createListenerId(url, listener);
        if (this.registeredListeners.add(listenerId)) {
            this.serviceDiscovery.addServiceInstancesChangedListener(listener);
        }
    }

    private String createListenerId(URL url, ServiceInstancesChangedListener listener) {
        return listener.getServiceName() + ":" + url.toString("version", "group", "protocol");
    }

    protected void subscribeURLs(URL subscribedURL, NotifyListener listener, String serviceName, Collection<ServiceInstance> serviceInstances) {
        if (CollectionUtils.isEmpty(serviceInstances)) {
            this.logger.warn(String.format("There is no instance in service[name : %s]", serviceName));
            return;
        }
        LinkedList<URL> subscribedURLs = new LinkedList<URL>();
        subscribedURLs.addAll(this.getExportedURLs(subscribedURL, serviceInstances));
        if (subscribedURLs.isEmpty()) {
            subscribedURLs.addAll(this.synthesizeSubscribedURLs(subscribedURL, serviceInstances));
        }
        listener.notify(subscribedURLs);
    }

    private List<URL> getExportedURLs(URL subscribedURL, Collection<ServiceInstance> instances) {
        List<ServiceInstance> serviceInstances = instances.stream().filter(ServiceInstance::isEnabled).filter(ServiceInstance::isHealthy).filter(ServiceInstanceMetadataUtils::isDubboServiceInstance).collect(Collectors.toList());
        int size = serviceInstances.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        this.prepareServiceRevisionExportedURLs(serviceInstances);
        List<URL> subscribedURLs = this.cloneExportedURLs(subscribedURL, serviceInstances);
        serviceInstances.clear();
        return subscribedURLs;
    }

    private void prepareServiceRevisionExportedURLs(List<ServiceInstance> serviceInstances) {
        this.executeExclusively(() -> {
            this.expungeStaleRevisionExportedURLs(serviceInstances);
            this.initializeRevisionExportedURLs(serviceInstances);
        });
    }

    private void initializeRevisionExportedURLs(List<ServiceInstance> serviceInstances) {
        this.initializeSelectedRevisionExportedURLs(serviceInstances);
        serviceInstances.forEach(this::initializeRevisionExportedURLs);
    }

    private void initializeSelectedRevisionExportedURLs(List<ServiceInstance> serviceInstances) {
        ServiceInstance selectedInstance;
        List<URL> revisionExportedURLs;
        for (int i = 0; i < serviceInstances.size() && !CollectionUtils.isNotEmpty(revisionExportedURLs = this.initializeRevisionExportedURLs(selectedInstance = this.selectServiceInstance(serviceInstances))); ++i) {
        }
    }

    private void expungeStaleRevisionExportedURLs(List<ServiceInstance> serviceInstances) {
        String serviceName = serviceInstances.get(0).getServiceName();
        Map<String, List<URL>> revisionExportedURLsMap = this.getRevisionExportedURLsMap(serviceName);
        if (revisionExportedURLsMap.isEmpty()) {
            return;
        }
        Set<String> existedRevisions = revisionExportedURLsMap.keySet();
        Set currentRevisions = serviceInstances.stream().map(ServiceInstanceMetadataUtils::getExportedServicesRevision).collect(Collectors.toSet());
        HashSet<String> staleRevisions = new HashSet<String>(existedRevisions);
        staleRevisions.removeAll(currentRevisions);
        staleRevisions.forEach(revisionExportedURLsMap::remove);
    }

    private List<URL> cloneExportedURLs(URL subscribedURL, Collection<ServiceInstance> serviceInstances) {
        if (CollectionUtils.isEmpty(serviceInstances)) {
            return Collections.emptyList();
        }
        LinkedList<URL> clonedExportedURLs = new LinkedList<URL>();
        serviceInstances.forEach(serviceInstance -> {
            String host = serviceInstance.getHost();
            this.getTemplateExportedURLs(subscribedURL, (ServiceInstance)serviceInstance).stream().map(templateURL -> templateURL.removeParameter("timestamp")).map(templateURL -> templateURL.removeParameter("pid")).map(templateURL -> {
                String protocol = templateURL.getProtocol();
                int port = ServiceInstanceMetadataUtils.getProtocolPort(serviceInstance, protocol);
                if (Objects.equals(templateURL.getHost(), host) && Objects.equals(templateURL.getPort(), port)) {
                    return templateURL;
                }
                URLBuilder clonedURLBuilder = URLBuilder.from(templateURL).setHost(host).setPort(port);
                return clonedURLBuilder.build();
            }).forEach(clonedExportedURLs::add);
        });
        return clonedExportedURLs;
    }

    private ServiceInstance selectServiceInstance(List<ServiceInstance> serviceInstances) {
        int size = serviceInstances.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return serviceInstances.get(0);
        }
        ServiceInstanceSelector selector = ExtensionLoader.getExtensionLoader(ServiceInstanceSelector.class).getAdaptiveExtension();
        return selector.select(this.getUrl(), serviceInstances);
    }

    private List<URL> getTemplateExportedURLs(URL subscribedURL, ServiceInstance selectedInstance) {
        List<URL> exportedURLs = this.getRevisionExportedURLs(selectedInstance);
        if (CollectionUtils.isEmpty(exportedURLs)) {
            return Collections.emptyList();
        }
        return ServiceDiscoveryRegistry.filterSubscribedURLs(subscribedURL, exportedURLs);
    }

    private List<URL> initializeRevisionExportedURLs(ServiceInstance serviceInstance) {
        if (serviceInstance == null) {
            return Collections.emptyList();
        }
        String serviceName = serviceInstance.getServiceName();
        String revision = ServiceInstanceMetadataUtils.getExportedServicesRevision(serviceInstance);
        Map<String, List<URL>> revisionExportedURLsMap = this.getRevisionExportedURLsMap(serviceName);
        List<URL> revisionExportedURLs = revisionExportedURLsMap.get(revision);
        boolean firstGet = false;
        if (revisionExportedURLs == null) {
            if (!revisionExportedURLsMap.isEmpty()) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn(String.format("The ServiceInstance[id: %s, host : %s , port : %s] has different revision : %s, please make sure the service [name : %s] is changing or not.", serviceInstance.getId(), serviceInstance.getHost(), serviceInstance.getPort(), revision, serviceInstance.getServiceName()));
                }
            } else {
                firstGet = true;
            }
            if ((revisionExportedURLs = this.getExportedURLs(serviceInstance)) != null) {
                revisionExportedURLsMap.put(revision, revisionExportedURLs);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(String.format("Get the exported URLs[size : %s, first : %s] from the target service instance [id: %s , service : %s , host : %s , port : %s , revision : %s]", revisionExportedURLs.size(), firstGet, serviceInstance.getId(), serviceInstance.getServiceName(), serviceInstance.getHost(), serviceInstance.getPort(), revision));
                }
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Get the exported URLs[size : %s] from cache, the instance[id: %s , service : %s , host : %s , port : %s , revision : %s]", revisionExportedURLs.size(), serviceInstance.getId(), serviceInstance.getServiceName(), serviceInstance.getHost(), serviceInstance.getPort(), revision));
        }
        return revisionExportedURLs;
    }

    private Map<String, List<URL>> getRevisionExportedURLsMap(String serviceName) {
        return this.serviceRevisionExportedURLsCache.computeIfAbsent(serviceName, s -> new LinkedHashMap());
    }

    private List<URL> getRevisionExportedURLs(ServiceInstance serviceInstance) {
        if (serviceInstance == null) {
            return Collections.emptyList();
        }
        String serviceName = serviceInstance.getServiceName();
        String revision = ServiceInstanceMetadataUtils.getExportedServicesRevision(serviceInstance);
        return this.getRevisionExportedURLs(serviceName, revision);
    }

    private List<URL> getRevisionExportedURLs(String serviceName, String revision) {
        return this.executeShared(() -> {
            Map<String, List<URL>> revisionExportedURLsMap = this.getRevisionExportedURLsMap(serviceName);
            List<URL> exportedURLs = revisionExportedURLsMap.get(revision);
            return exportedURLs != null ? new ArrayList<URL>(exportedURLs) : Collections.emptyList();
        });
    }

    private List<URL> getExportedURLs(ServiceInstance providerServiceInstance) {
        List<URL> exportedURLs = null;
        String metadataStorageType = ServiceInstanceMetadataUtils.getMetadataStorageType(providerServiceInstance);
        try {
            MetadataService metadataService = MetadataServiceProxyFactory.getExtension(metadataStorageType).getProxy(providerServiceInstance);
            if (metadataService != null) {
                SortedSet<String> urls = metadataService.getExportedURLs();
                exportedURLs = MetadataService.toURLs(urls);
            }
        }
        catch (Throwable e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error(String.format("Failed to get the exported URLs from the target service instance[%s]", providerServiceInstance), e);
            }
            exportedURLs = null;
        }
        return exportedURLs;
    }

    private void executeExclusively(Runnable runnable) {
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            runnable.run();
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T executeShared(Supplier<T> supplier) {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            readLock.unlock();
        }
    }

    private Collection<? extends URL> synthesizeSubscribedURLs(URL subscribedURL, Collection<ServiceInstance> serviceInstances) {
        return this.subscribedURLsSynthesizers.stream().filter(synthesizer -> synthesizer.supports(subscribedURL)).map(synthesizer -> synthesizer.synthesize(subscribedURL, serviceInstances)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    protected Set<String> getServices(URL subscribedURL) {
        Set<Object> subscribedServices = new LinkedHashSet();
        String serviceNames = subscribedURL.getParameter("provided-by");
        if (StringUtils.isNotEmpty(serviceNames)) {
            subscribedServices = ServiceDiscoveryRegistry.parseServices(serviceNames);
        }
        if (CollectionUtils.isEmpty(subscribedServices) && CollectionUtils.isEmpty(subscribedServices = this.findMappedServices(subscribedURL))) {
            subscribedServices = this.getSubscribedServices();
        }
        return subscribedServices;
    }

    public static Set<String> parseServices(String literalServices) {
        return StringUtils.isBlank(literalServices) ? Collections.emptySet() : Collections.unmodifiableSet(Stream.of(literalServices.split(",")).map(String::trim).filter(StringUtils::isNotEmpty).collect(Collectors.toSet()));
    }

    public Set<String> getSubscribedServices() {
        return this.subscribedServices;
    }

    protected Set<String> findMappedServices(URL subscribedURL) {
        String serviceInterface = subscribedURL.getServiceInterface();
        String group = subscribedURL.getParameter("group");
        String version = subscribedURL.getParameter("version");
        String protocol = subscribedURL.getParameter("protocol", "dubbo");
        return this.serviceNameMapping.get(serviceInterface, group, version, protocol);
    }

    public static ServiceDiscoveryRegistry create(URL registryURL) {
        return ServiceDiscoveryRegistry.supports(registryURL) ? new ServiceDiscoveryRegistry(registryURL) : null;
    }

    public static boolean supports(URL registryURL) {
        return "service".equalsIgnoreCase(registryURL.getParameter("registry-type"));
    }

    private static List<URL> filterSubscribedURLs(URL subscribedURL, List<URL> exportedURLs) {
        return exportedURLs.stream().filter(url -> ServiceDiscoveryRegistry.isSameServiceInterface(subscribedURL, url)).filter(url -> ServiceDiscoveryRegistry.isSameParameter(subscribedURL, url, "version")).filter(url -> ServiceDiscoveryRegistry.isSameParameter(subscribedURL, url, "group")).filter(url -> ServiceDiscoveryRegistry.isCompatibleProtocol(subscribedURL, url)).collect(Collectors.toList());
    }

    private static boolean isSameServiceInterface(URL one, URL another) {
        return Objects.equals(one.getServiceInterface(), another.getServiceInterface());
    }

    private static boolean isSameParameter(URL one, URL another, String key) {
        return Objects.equals(one.getParameter(key), another.getParameter(key));
    }

    private static boolean isCompatibleProtocol(URL one, URL another) {
        String protocol = one.getParameter("protocol");
        return ServiceDiscoveryRegistry.isCompatibleProtocol(protocol, another);
    }

    private static boolean isCompatibleProtocol(String protocol, URL targetURL) {
        return protocol == null || Objects.equals(protocol, targetURL.getParameter("protocol")) || Objects.equals(protocol, targetURL.getProtocol());
    }
}

