/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.command.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.support.AbstractRegistry;
import org.apache.dubbo.registry.support.AbstractRegistryFactory;
import org.apache.dubbo.rpc.model.ConsumerModel;
import org.apache.dubbo.rpc.model.ProviderModel;

public class ServiceCheckUtils {
    public static boolean isRegistered(ProviderModel providerModel) {
        AbstractRegistry abstractRegistry;
        Collection<Registry> registries = AbstractRegistryFactory.getRegistries();
        return CollectionUtils.isNotEmpty(registries) && (abstractRegistry = (AbstractRegistry)registries.iterator().next()).getRegistered().stream().anyMatch(url -> url.getServiceKey().equals(providerModel.getServiceKey()));
    }

    public static int getConsumerAddressNum(ConsumerModel consumerModel) {
        int num = 0;
        Collection<Registry> registries = AbstractRegistryFactory.getRegistries();
        if (CollectionUtils.isNotEmpty(registries)) {
            AbstractRegistry abstractRegistry = (AbstractRegistry)registries.iterator().next();
            for (Map.Entry<URL, Map<String, List<URL>>> entry : abstractRegistry.getNotified().entrySet()) {
                if (!entry.getKey().getServiceKey().equals(consumerModel.getServiceKey()) || !CollectionUtils.isNotEmptyMap(entry.getValue())) continue;
                num = entry.getValue().size();
            }
        }
        return num;
    }
}

