/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.configcenter.support.nacos;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.AbstractSharedListener;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.config.http.HttpAgent;
import com.alibaba.nacos.client.config.impl.HttpSimpleClient;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.configcenter.ConfigChangeType;
import org.apache.dubbo.common.config.configcenter.ConfigChangedEvent;
import org.apache.dubbo.common.config.configcenter.ConfigurationListener;
import org.apache.dubbo.common.config.configcenter.DynamicConfiguration;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;

public class NacosDynamicConfiguration
implements DynamicConfiguration {
    private static final String GET_CONFIG_KEYS_PATH = "/v1/cs/configs";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final long DEFAULT_TIMEOUT = 5000L;
    private Properties nacosProperties;
    private final ConfigService configService;
    private HttpAgent httpAgent;
    private final ConcurrentMap<String, NacosConfigListener> watchListenerMap;

    NacosDynamicConfiguration(URL url) {
        this.nacosProperties = this.buildNacosProperties(url);
        this.configService = this.buildConfigService(url);
        this.httpAgent = this.getHttpAgent(this.configService);
        this.watchListenerMap = new ConcurrentHashMap<String, NacosConfigListener>();
    }

    private ConfigService buildConfigService(URL url) {
        ConfigService configService = null;
        try {
            configService = NacosFactory.createConfigService((Properties)this.nacosProperties);
        }
        catch (NacosException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error(e.getErrMsg(), e);
            }
            throw new IllegalStateException(e);
        }
        return configService;
    }

    private HttpAgent getHttpAgent(ConfigService configService) {
        HttpAgent agent = null;
        try {
            Field field = configService.getClass().getDeclaredField("agent");
            field.setAccessible(true);
            agent = (HttpAgent)field.get(configService);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return agent;
    }

    private Properties buildNacosProperties(URL url) {
        Properties properties = new Properties();
        this.setServerAddr(url, properties);
        NacosDynamicConfiguration.setProperties(url, properties);
        return properties;
    }

    private void setServerAddr(URL url, Properties properties) {
        StringBuilder serverAddrBuilder = new StringBuilder(url.getHost()).append(":").append(url.getPort());
        String backup = url.getParameter("backup");
        if (backup != null) {
            serverAddrBuilder.append(",").append(backup);
        }
        String serverAddr = serverAddrBuilder.toString();
        properties.put("serverAddr", serverAddr);
    }

    private static void setProperties(URL url, Properties properties) {
        NacosDynamicConfiguration.putPropertyIfAbsent(url, properties, "com.alibaba.nacos.naming.log.filename");
        NacosDynamicConfiguration.putPropertyIfAbsent(url, properties, "isUseCloudNamespaceParsing");
        NacosDynamicConfiguration.putPropertyIfAbsent(url, properties, "isUseEndpointParsingRule");
        NacosDynamicConfiguration.putPropertyIfAbsent(url, properties, "endpoint");
        NacosDynamicConfiguration.putPropertyIfAbsent(url, properties, "endpointPort");
        NacosDynamicConfiguration.putPropertyIfAbsent(url, properties, "namespace");
        NacosDynamicConfiguration.putPropertyIfAbsent(url, properties, "accessKey");
        NacosDynamicConfiguration.putPropertyIfAbsent(url, properties, "secretKey");
        NacosDynamicConfiguration.putPropertyIfAbsent(url, properties, "ramRoleName");
        NacosDynamicConfiguration.putPropertyIfAbsent(url, properties, "contextPath");
        NacosDynamicConfiguration.putPropertyIfAbsent(url, properties, "clusterName");
        NacosDynamicConfiguration.putPropertyIfAbsent(url, properties, "encode");
        NacosDynamicConfiguration.putPropertyIfAbsent(url, properties, "configLongPollTimeout");
        NacosDynamicConfiguration.putPropertyIfAbsent(url, properties, "configRetryTime");
        NacosDynamicConfiguration.putPropertyIfAbsent(url, properties, "maxRetry");
        NacosDynamicConfiguration.putPropertyIfAbsent(url, properties, "enableRemoteSyncConfig");
        NacosDynamicConfiguration.putPropertyIfAbsent(url, properties, "namingLoadCacheAtStart", "true");
        NacosDynamicConfiguration.putPropertyIfAbsent(url, properties, "namingClientBeatThreadCount");
        NacosDynamicConfiguration.putPropertyIfAbsent(url, properties, "namingPollingThreadCount");
    }

    private static void putPropertyIfAbsent(URL url, Properties properties, String propertyName) {
        String propertyValue = url.getParameter(propertyName);
        if (StringUtils.isNotEmpty(propertyValue)) {
            properties.setProperty(propertyName, propertyValue);
        }
    }

    private static void putPropertyIfAbsent(URL url, Properties properties, String propertyName, String defaultValue) {
        String propertyValue = url.getParameter(propertyName);
        if (StringUtils.isNotEmpty(propertyValue)) {
            properties.setProperty(propertyName, propertyValue);
        } else {
            properties.setProperty(propertyName, defaultValue);
        }
    }

    private NacosConfigListener createTargetListener(String key, String group) {
        NacosConfigListener configListener = new NacosConfigListener();
        configListener.fillContext(key, group);
        return configListener;
    }

    @Override
    public void addListener(String key, String group, ConfigurationListener listener) {
        String resolvedGroup = this.resolveGroup(group);
        String listenerKey = this.buildListenerKey(key, group);
        NacosConfigListener nacosConfigListener = this.watchListenerMap.computeIfAbsent(listenerKey, k -> this.createTargetListener(key, resolvedGroup));
        nacosConfigListener.addListener(listener);
        try {
            this.configService.addListener(key, resolvedGroup, (Listener)nacosConfigListener);
        }
        catch (NacosException e) {
            this.logger.error(e.getMessage());
        }
    }

    @Override
    public void removeListener(String key, String group, ConfigurationListener listener) {
        String listenerKey = this.buildListenerKey(key, group);
        NacosConfigListener eventListener = (NacosConfigListener)((Object)this.watchListenerMap.get(listenerKey));
        if (eventListener != null) {
            eventListener.removeListener(listener);
        }
    }

    @Override
    public String getConfig(String key, String group, long timeout) throws IllegalStateException {
        String resolvedGroup = this.resolveGroup(group);
        try {
            long nacosTimeout;
            long l = nacosTimeout = timeout < 0L ? this.getDefaultTimeout() : timeout;
            if (StringUtils.isEmpty(resolvedGroup)) {
                resolvedGroup = "dubbo";
            }
            return this.configService.getConfig(key, resolvedGroup, nacosTimeout);
        }
        catch (NacosException e) {
            this.logger.error(e.getMessage());
            return null;
        }
    }

    @Override
    public Object getInternalProperty(String key) {
        try {
            return this.configService.getConfig(key, "dubbo", this.getDefaultTimeout());
        }
        catch (NacosException e) {
            this.logger.error(e.getMessage());
            return null;
        }
    }

    @Override
    public boolean publishConfig(String key, String group, String content) {
        boolean published = false;
        String resolvedGroup = this.resolveGroup(group);
        try {
            String value = this.configService.getConfig(key, resolvedGroup, this.getDefaultTimeout());
            if (StringUtils.isNotEmpty(value)) {
                content = value + "," + content;
            }
            published = this.configService.publishConfig(key, resolvedGroup, content);
        }
        catch (NacosException e) {
            this.logger.error(e.getErrMsg());
        }
        return published;
    }

    @Override
    public long getDefaultTimeout() {
        return 5000L;
    }

    @Override
    public SortedSet<String> getConfigKeys(String group) {
        TreeSet<String> keys;
        block2: {
            keys = new TreeSet<String>();
            try {
                List<String> paramsValues = Arrays.asList("search", "accurate", "dataId", "", "group", this.resolveGroup(group), "pageNo", "1", "pageSize", String.valueOf(Integer.MAX_VALUE));
                String encoding = this.getProperty("encode", "UTF-8");
                HttpSimpleClient.HttpResult result = this.httpAgent.httpGet(GET_CONFIG_KEYS_PATH, Collections.emptyList(), paramsValues, encoding, 5000L);
                Stream<String> keysStream = this.toKeysStream(result.content);
                keysStream.forEach(keys::add);
            }
            catch (IOException e) {
                if (!this.logger.isErrorEnabled()) break block2;
                this.logger.error(e.getMessage(), e);
            }
        }
        return keys;
    }

    private Stream<String> toKeysStream(String content) {
        JSONObject jsonObject = JSON.parseObject((String)content);
        JSONArray pageItems = jsonObject.getJSONArray("pageItems");
        return pageItems.stream().map(object -> (JSONObject)object).map(json -> json.getString("dataId"));
    }

    private String getProperty(String name, String defaultValue) {
        return this.nacosProperties.getProperty(name, defaultValue);
    }

    protected String buildListenerKey(String key, String group) {
        return key + '-' + this.resolveGroup(group);
    }

    protected String resolveGroup(String group) {
        return group.replace('/', '-');
    }

    public class NacosConfigListener
    extends AbstractSharedListener {
        private Set<ConfigurationListener> listeners = new CopyOnWriteArraySet<ConfigurationListener>();
        private Map<String, String> cacheData = new ConcurrentHashMap<String, String>();

        public Executor getExecutor() {
            return null;
        }

        public void innerReceive(String dataId, String group, String configInfo) {
            String oldValue = this.cacheData.get(dataId);
            ConfigChangedEvent event = new ConfigChangedEvent(dataId, group, configInfo, this.getChangeType(configInfo, oldValue));
            if (configInfo == null) {
                this.cacheData.remove(dataId);
            } else {
                this.cacheData.put(dataId, configInfo);
            }
            this.listeners.forEach(listener -> listener.process(event));
        }

        void addListener(ConfigurationListener configurationListener) {
            this.listeners.add(configurationListener);
        }

        void removeListener(ConfigurationListener configurationListener) {
            this.listeners.remove(configurationListener);
        }

        private ConfigChangeType getChangeType(String configInfo, String oldValue) {
            if (StringUtils.isBlank(configInfo)) {
                return ConfigChangeType.DELETED;
            }
            if (StringUtils.isBlank(oldValue)) {
                return ConfigChangeType.ADDED;
            }
            return ConfigChangeType.MODIFIED;
        }
    }
}

