/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring;

import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.ServiceConfig;
import org.apache.dubbo.config.annotation.Service;
import org.apache.dubbo.config.spring.context.event.ServiceBeanExportedEvent;
import org.apache.dubbo.config.spring.extension.SpringExtensionFactory;
import org.apache.dubbo.config.support.Parameter;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;

public class ServiceBean<T>
extends ServiceConfig<T>
implements InitializingBean,
DisposableBean,
ApplicationContextAware,
BeanNameAware,
ApplicationEventPublisherAware {
    private static final long serialVersionUID = 213195494150089726L;
    private final transient Service service;
    private transient ApplicationContext applicationContext;
    private transient String beanName;
    private ApplicationEventPublisher applicationEventPublisher;

    public ServiceBean() {
        this.service = null;
    }

    public ServiceBean(Service service) {
        super(service);
        this.service = service;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        SpringExtensionFactory.addApplicationContext(applicationContext);
    }

    @Override
    public void setBeanName(String name) {
        this.beanName = name;
    }

    public Service getService() {
        return this.service;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (StringUtils.isEmpty(this.getPath()) && StringUtils.isNotEmpty(this.beanName) && StringUtils.isNotEmpty(this.getInterface()) && this.beanName.startsWith(this.getInterface())) {
            this.setPath(this.beanName);
        }
    }

    @Parameter(excluded=true)
    public String getBeanName() {
        return this.beanName;
    }

    @Override
    public void exported() {
        super.exported();
        this.publishExportEvent();
    }

    private void publishExportEvent() {
        ServiceBeanExportedEvent exportEvent = new ServiceBeanExportedEvent(this);
        this.applicationEventPublisher.publishEvent(exportEvent);
    }

    @Override
    public void destroy() throws Exception {
    }

    @Override
    protected Class getServiceClass(T ref) {
        if (AopUtils.isAopProxy(ref)) {
            return AopUtils.getTargetClass(ref);
        }
        return super.getServiceClass(ref);
    }

    @Override
    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }
}

