/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.cache.support.expiring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ExpiringMap<K, V>
implements Map<K, V> {
    private static final int DEFAULT_TIME_TO_LIVE = 180;
    private static final int DEFAULT_EXPIRATION_INTERVAL = 1;
    private static AtomicInteger expireCount = new AtomicInteger(1);
    private final ConcurrentHashMap<K, ExpiryObject> delegateMap;
    private final ExpireThread expireThread;

    public ExpiringMap() {
        this(180, 1);
    }

    public ExpiringMap(int timeToLive) {
        this(timeToLive, 1);
    }

    public ExpiringMap(int timeToLive, int expirationInterval) {
        this(new ConcurrentHashMap(), timeToLive, expirationInterval);
    }

    private ExpiringMap(ConcurrentHashMap<K, ExpiryObject> delegateMap, int timeToLive, int expirationInterval) {
        this.delegateMap = delegateMap;
        this.expireThread = new ExpireThread();
        this.expireThread.setTimeToLive(timeToLive);
        this.expireThread.setExpirationInterval(expirationInterval);
    }

    @Override
    public V put(K key, V value) {
        ExpiryObject answer = this.delegateMap.put(key, new ExpiryObject(key, value, System.currentTimeMillis()));
        if (answer == null) {
            return null;
        }
        return answer.getValue();
    }

    @Override
    public V get(Object key) {
        ExpiryObject object = this.delegateMap.get(key);
        if (object != null) {
            object.setLastAccessTime(System.currentTimeMillis());
            return object.getValue();
        }
        return null;
    }

    @Override
    public V remove(Object key) {
        ExpiryObject answer = this.delegateMap.remove(key);
        if (answer == null) {
            return null;
        }
        return answer.getValue();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegateMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegateMap.containsValue(value);
    }

    @Override
    public int size() {
        return this.delegateMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegateMap.isEmpty();
    }

    @Override
    public void clear() {
        this.delegateMap.clear();
        this.expireThread.stopExpiring();
    }

    @Override
    public int hashCode() {
        return this.delegateMap.hashCode();
    }

    @Override
    public Set<K> keySet() {
        return this.delegateMap.keySet();
    }

    @Override
    public boolean equals(Object obj) {
        return this.delegateMap.equals(obj);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> inMap) {
        for (Map.Entry<K, V> e : inMap.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public Collection<V> values() {
        ArrayList list = new ArrayList();
        Set<Map.Entry<K, ExpiryObject>> delegatedSet = this.delegateMap.entrySet();
        for (Map.Entry<K, ExpiryObject> entry : delegatedSet) {
            ExpiryObject value = entry.getValue();
            list.add(value.getValue());
        }
        return list;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    public ExpireThread getExpireThread() {
        return this.expireThread;
    }

    public int getExpirationInterval() {
        return this.expireThread.getExpirationInterval();
    }

    public void setExpirationInterval(int expirationInterval) {
        this.expireThread.setExpirationInterval(expirationInterval);
    }

    public int getTimeToLive() {
        return this.expireThread.getTimeToLive();
    }

    public void setTimeToLive(int timeToLive) {
        this.expireThread.setTimeToLive(timeToLive);
    }

    public String toString() {
        return "ExpiringMap{delegateMap=" + this.delegateMap.toString() + ", expireThread=" + this.expireThread.toString() + '}';
    }

    static /* synthetic */ AtomicInteger access$000() {
        return expireCount;
    }

    public class ExpireThread
    implements Runnable {
        private long timeToLiveMillis;
        private long expirationIntervalMillis;
        private volatile boolean running = false;
        private final Thread expirerThread = new Thread((Runnable)this, "ExpiryMapExpire-" + ExpiringMap.access$000().getAndIncrement());

        public String toString() {
            return "ExpireThread{, timeToLiveMillis=" + this.timeToLiveMillis + ", expirationIntervalMillis=" + this.expirationIntervalMillis + ", running=" + this.running + ", expirerThread=" + this.expirerThread + '}';
        }

        public ExpireThread() {
            this.expirerThread.setDaemon(true);
        }

        @Override
        public void run() {
            while (this.running) {
                this.processExpires();
                try {
                    Thread.sleep(this.expirationIntervalMillis);
                }
                catch (InterruptedException e) {
                    this.running = false;
                }
            }
        }

        private void processExpires() {
            long timeNow = System.currentTimeMillis();
            for (ExpiryObject o : ExpiringMap.this.delegateMap.values()) {
                long timeIdle;
                if (this.timeToLiveMillis <= 0L || (timeIdle = timeNow - o.getLastAccessTime()) < this.timeToLiveMillis) continue;
                ExpiringMap.this.delegateMap.remove(o.getKey());
            }
        }

        public void startExpiring() {
            if (!this.running) {
                this.running = true;
                this.expirerThread.start();
            }
        }

        public void startExpiryIfNotStarted() {
            if (this.running) {
                return;
            }
            this.startExpiring();
        }

        public void stopExpiring() {
            if (this.running) {
                this.running = false;
                this.expirerThread.interrupt();
            }
        }

        public boolean isRunning() {
            return this.running;
        }

        public int getTimeToLive() {
            return (int)this.timeToLiveMillis / 1000;
        }

        public void setTimeToLive(long timeToLive) {
            this.timeToLiveMillis = timeToLive * 1000L;
        }

        public int getExpirationInterval() {
            return (int)this.expirationIntervalMillis / 1000;
        }

        public void setExpirationInterval(long expirationInterval) {
            this.expirationIntervalMillis = expirationInterval * 1000L;
        }
    }

    private class ExpiryObject {
        private K key;
        private V value;
        private AtomicLong lastAccessTime;

        ExpiryObject(K key, V value, long lastAccessTime) {
            if (value == null) {
                throw new IllegalArgumentException("An expiring object cannot be null.");
            }
            this.key = key;
            this.value = value;
            this.lastAccessTime = new AtomicLong(lastAccessTime);
        }

        public long getLastAccessTime() {
            return this.lastAccessTime.get();
        }

        public void setLastAccessTime(long lastAccessTime) {
            this.lastAccessTime.set(lastAccessTime);
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public boolean equals(Object obj) {
            return this.value.equals(obj);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "ExpiryObject{key=" + this.key + ", value=" + this.value + ", lastAccessTime=" + this.lastAccessTime + '}';
        }
    }
}

