/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.spring.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.AnnotatedBeanDefinitionReader;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public abstract class AnnotatedBeanDefinitionRegistryUtils {
    private static final Log logger = LogFactory.getLog(AnnotatedBeanDefinitionRegistryUtils.class);

    public static boolean isPresentBean(BeanDefinitionRegistry registry, Class<?> annotatedClass) {
        boolean present = false;
        String[] beanNames = registry.getBeanDefinitionNames();
        ClassLoader classLoader = annotatedClass.getClassLoader();
        for (String beanName : beanNames) {
            AnnotationMetadata annotationMetadata;
            String className;
            Class<?> targetClass;
            BeanDefinition beanDefinition = registry.getBeanDefinition(beanName);
            if (!(beanDefinition instanceof AnnotatedBeanDefinition) || !(present = ObjectUtils.nullSafeEquals(targetClass = ClassUtils.resolveClassName(className = (annotationMetadata = ((AnnotatedBeanDefinition)beanDefinition).getMetadata()).getClassName(), classLoader), annotatedClass))) continue;
            if (!logger.isDebugEnabled()) break;
            logger.debug(String.format("The annotatedClass[class : %s , bean name : %s] was present in registry[%s]", className, beanName, registry));
            break;
        }
        return present;
    }

    public static void registerBeans(BeanDefinitionRegistry registry, Class<?> ... annotatedClasses) {
        if (ObjectUtils.isEmpty(annotatedClasses)) {
            return;
        }
        Iterator<Class<?>> iterator = new ArrayList(Arrays.asList(annotatedClasses)).iterator();
        while (iterator.hasNext()) {
            Class<?> annotatedClass = iterator.next();
            if (!AnnotatedBeanDefinitionRegistryUtils.isPresentBean(registry, annotatedClass)) continue;
            iterator.remove();
        }
        AnnotatedBeanDefinitionReader reader = new AnnotatedBeanDefinitionReader(registry);
        if (logger.isDebugEnabled()) {
            logger.debug(registry.getClass().getSimpleName() + " will register annotated classes : " + Arrays.asList(annotatedClasses) + " .");
        }
        reader.register(annotatedClasses);
    }

    public static int scanBasePackages(BeanDefinitionRegistry registry, String ... basePackages) {
        int count = 0;
        if (!ObjectUtils.isEmpty(basePackages)) {
            boolean debugEnabled = logger.isDebugEnabled();
            if (debugEnabled) {
                logger.debug(registry.getClass().getSimpleName() + " will scan base packages " + Arrays.asList(basePackages) + ".");
            }
            List<String> registeredBeanNames = Arrays.asList(registry.getBeanDefinitionNames());
            ClassPathBeanDefinitionScanner classPathBeanDefinitionScanner = new ClassPathBeanDefinitionScanner(registry);
            count = classPathBeanDefinitionScanner.scan(basePackages);
            ArrayList<String> scannedBeanNames = new ArrayList<String>(count);
            scannedBeanNames.addAll(Arrays.asList(registry.getBeanDefinitionNames()));
            scannedBeanNames.removeAll(registeredBeanNames);
            if (debugEnabled) {
                logger.debug("The Scanned Components[ count : " + count + "] under base packages " + Arrays.asList(basePackages) + " : ");
            }
            for (String scannedBeanName : scannedBeanNames) {
                BeanDefinition scannedBeanDefinition = registry.getBeanDefinition(scannedBeanName);
                if (!debugEnabled) continue;
                logger.debug("Component [ name : " + scannedBeanName + " , class : " + scannedBeanDefinition.getBeanClassName() + " ]");
            }
        }
        return count;
    }
}

