/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.spring.beans.factory.annotation;

import com.alibaba.spring.beans.factory.annotation.ConfigurationBeanBindingRegistrar;
import com.alibaba.spring.context.config.ConfigurationBeanBinder;
import com.alibaba.spring.context.config.ConfigurationBeanCustomizer;
import com.alibaba.spring.context.config.DefaultConfigurationBeanBinder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class ConfigurationBeanBindingPostProcessor
implements BeanFactoryPostProcessor,
BeanPostProcessor {
    public static final String BEAN_NAME = "configurationBeanBindingPostProcessor";
    static final String CONFIGURATION_PROPERTIES_ATTRIBUTE_NAME = "configurationProperties";
    static final String IGNORE_UNKNOWN_FIELDS_ATTRIBUTE_NAME = "ignoreUnknownFields";
    static final String IGNORE_INVALID_FIELDS_ATTRIBUTE_NAME = "ignoreInvalidFields";
    private final Log log = LogFactory.getLog(this.getClass());
    private ConfigurableListableBeanFactory beanFactory;
    private ConfigurationBeanBinder configurationBeanBinder;
    private List<ConfigurationBeanCustomizer> configurationBeanCustomizers = Collections.emptyList();

    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        this.initConfigurationBeanBinder();
        this.initBindConfigurationBeanCustomizers();
    }

    @Override
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        BeanDefinition beanDefinition = this.getNullableBeanDefinition(beanName);
        if (this.isConfigurationBean(bean, beanDefinition)) {
            this.bindConfigurationBean(bean, beanDefinition);
            this.customize(beanName, bean);
        }
        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public ConfigurationBeanBinder getConfigurationBeanBinder() {
        return this.configurationBeanBinder;
    }

    public void setConfigurationBeanBinder(ConfigurationBeanBinder configurationBeanBinder) {
        this.configurationBeanBinder = configurationBeanBinder;
    }

    private BeanDefinition getNullableBeanDefinition(String beanName) {
        return this.beanFactory.containsBeanDefinition(beanName) ? this.beanFactory.getBeanDefinition(beanName) : null;
    }

    private boolean isConfigurationBean(Object bean, BeanDefinition beanDefinition) {
        return beanDefinition != null && ConfigurationBeanBindingRegistrar.ENABLE_CONFIGURATION_BINDING_CLASS.equals(beanDefinition.getSource()) && ObjectUtils.nullSafeEquals(this.getBeanClassName(bean), beanDefinition.getBeanClassName());
    }

    private String getBeanClassName(Object bean) {
        return ClassUtils.getUserClass(bean.getClass()).getName();
    }

    private void bindConfigurationBean(Object configurationBean, BeanDefinition beanDefinition) {
        Map<String, Object> configurationProperties = ConfigurationBeanBindingPostProcessor.getConfigurationProperties(beanDefinition);
        boolean ignoreUnknownFields = ConfigurationBeanBindingPostProcessor.getIgnoreUnknownFields(beanDefinition);
        boolean ignoreInvalidFields = ConfigurationBeanBindingPostProcessor.getIgnoreInvalidFields(beanDefinition);
        this.configurationBeanBinder.bind(configurationProperties, ignoreUnknownFields, ignoreInvalidFields, configurationBean);
        if (this.log.isInfoEnabled()) {
            this.log.info("The configuration bean [" + configurationBean + "] have been binding by the configuration properties [" + configurationProperties + "]");
        }
    }

    private void initConfigurationBeanBinder() {
        if (this.configurationBeanBinder == null) {
            try {
                this.configurationBeanBinder = this.beanFactory.getBean(ConfigurationBeanBinder.class);
            }
            catch (BeansException ignored) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("configurationBeanBinder Bean can't be found in ApplicationContext.");
                }
                this.configurationBeanBinder = this.defaultConfigurationBeanBinder();
            }
        }
    }

    private void initBindConfigurationBeanCustomizers() {
        Collection<ConfigurationBeanCustomizer> customizers = BeanFactoryUtils.beansOfTypeIncludingAncestors(this.beanFactory, ConfigurationBeanCustomizer.class).values();
        this.configurationBeanCustomizers = new ArrayList<ConfigurationBeanCustomizer>(customizers);
        AnnotationAwareOrderComparator.sort(this.configurationBeanCustomizers);
    }

    private void customize(String beanName, Object configurationBean) {
        for (ConfigurationBeanCustomizer customizer : this.configurationBeanCustomizers) {
            customizer.customize(beanName, configurationBean);
        }
    }

    private ConfigurationBeanBinder defaultConfigurationBeanBinder() {
        return new DefaultConfigurationBeanBinder();
    }

    static void initBeanMetadataAttributes(AbstractBeanDefinition beanDefinition, Map<String, Object> configurationProperties, boolean ignoreUnknownFields, boolean ignoreInvalidFields) {
        beanDefinition.setAttribute(CONFIGURATION_PROPERTIES_ATTRIBUTE_NAME, configurationProperties);
        beanDefinition.setAttribute(IGNORE_UNKNOWN_FIELDS_ATTRIBUTE_NAME, ignoreUnknownFields);
        beanDefinition.setAttribute(IGNORE_INVALID_FIELDS_ATTRIBUTE_NAME, ignoreInvalidFields);
    }

    private static <T> T getAttribute(BeanDefinition beanDefinition, String attributeName) {
        return (T)beanDefinition.getAttribute(attributeName);
    }

    private static Map<String, Object> getConfigurationProperties(BeanDefinition beanDefinition) {
        return (Map)ConfigurationBeanBindingPostProcessor.getAttribute(beanDefinition, CONFIGURATION_PROPERTIES_ATTRIBUTE_NAME);
    }

    private static boolean getIgnoreUnknownFields(BeanDefinition beanDefinition) {
        return (Boolean)ConfigurationBeanBindingPostProcessor.getAttribute(beanDefinition, IGNORE_UNKNOWN_FIELDS_ATTRIBUTE_NAME);
    }

    private static boolean getIgnoreInvalidFields(BeanDefinition beanDefinition) {
        return (Boolean)ConfigurationBeanBindingPostProcessor.getAttribute(beanDefinition, IGNORE_INVALID_FIELDS_ATTRIBUTE_NAME);
    }
}

