import os, re
import paramiko
from lib.ssh.sshOperation import SSHOperation
from resources.storage.input_opt import excelParser

OPT_USER = "root"
ENV_PREPARE = "env_ready"
ENV_OPTIMIZE = "scripts"


class CommonMethod(object):
    @staticmethod
    def checkServerReachable(server_ip, server_user, server_passwd, server_port=22):
        try:
            import paramiko
            client = paramiko.Transport((server_ip, int(server_port)))
            client.connect(username=server_user, password=server_passwd)
            client.close()
            return 1
        except Exception as e:
            print("---错误原因--------", e)
            return 0
        return 1


class ConfigReader(object):
    def __init__(self, ip):
        # self.ep = excelParser("input/ceph_input.xlsx", "scripts/conf/")
        self.ep = excelParser("input/{0}.xlsx".format(ip), "scripts/conf/")

    def getConfig(self):
        self.ep.content_parse()

    def parseOutput(self):
        self.ep.output_config_print()


class RemoteExecute(object):
    def __init__(self, ip, username, password):
        self.dir_path = os.path.abspath(os.path.dirname(__file__))
        t = paramiko.Transport(sock=(ip, 22))
        t.connect(username=username, password=password)
        self.sftp = paramiko.SFTPClient.from_transport(t)
        self.ssh = SSHOperation()
        self.ssh.sshConnect(ip, 22, username, password)
        # self.ssh.channelSendCmd("mkdir -p /root/" + ENV_PREPARE)

    def __get_all_files_in_local_dir(self, local_dir):
        # 保存所有文件的列表
        all_files = list()
        all_dirs = list()

        # 获取当前指定目录下的所有目录及文件，包含属性值
        files = os.listdir(local_dir)
        for x in files:
            # local_dir目录中每一个文件或目录的完整路径
            filename = os.path.join(local_dir, x)
            # 如果是目录，则递归处理该目录
            if os.path.isdir(filename):
                all_dirs.append(filename)
            else:
                all_files.append(filename)
        return all_files, all_dirs

    def sftp_put_dir(self, remote_dir, local_dir):
        try:
            localpath = self.dir_path + "/" + local_dir
            # 去掉路字符最后的字符'/'，如果有的话
            if remote_dir[-1] != '/':
                remote_dir = remote_dir + "/"
            remotepath = remote_dir
            self.ssh.channelSendCmd("mkdir -p " + remotepath)
            # 获取本地指定目录及其子目录下的所有文件
            all_files, all_dirs = self.__get_all_files_in_local_dir(localpath)
            # 依次put每一个文件
            for x in all_files:
                filename = os.path.split(x)[-1]
                remote_filename = remotepath + '/' + filename
                print('Put文件%s传输中...' % filename)
                self.sftp.put(x, remote_filename)

            for x in all_dirs:
                dirname = os.path.split(x)[-1]
                self.sftp_put_dir(remote_dir + '/' + dirname, local_dir + "/" + dirname)

        except Exception as e:
            print("---错误原因--------", e)
            return 0
        return 1

    def uploadallScript(self, remotedir, localdir):
        upload_result = self.sftp_put_dir(remotedir, localdir)
        # 将路径下Windows格式的脚本转换为Unix格式
        self.ssh.channelSendCmd("find " + remotedir + " -type f -print0 | xargs -0 dos2unix --")
        return upload_result

    def exec_remote_cmd(self, cmd):
        # self.ssh.channelSendCmd('ls')
        result = self.ssh.channelSendCmd(cmd, time_out=300)
        return result

    # 检查结果是否正确执行
    def check_result(self):
        return True

    def close(self):
        self.sftp.close()
        self.ssh.disonnectSSH()

    def modifyKeyLineOfFile(self, **kwargs):
        """
        modifyKeyLineOfFile(filePath='c:/test/test/中文.txt', oldStr="汉语",newStr="dd中文")
        :param kwargs: {filePath:'c:/test/test/中文.txt', oldStr:"汉语", newStr:"dd中文"}
        :return:
        """
        try:
            filePath = None
            if 'filePath' in kwargs.keys():
                filePath = kwargs['filePath'].encode("gbk").decode("utf-8")
            if filePath is None:
                return 0

            realpath = self.dir_path + "/" + filePath

            if 'content' in kwargs.keys():
                content = kwargs['content']
                f = open(realpath, "w+")
                f.writelines(content)
                f.close()
            elif 'delete' in kwargs.keys():
                delete = kwargs['delete']
                with open(realpath, "r") as f1, open("%s.bak" % realpath, "w") as f2:
                    for line in f1:
                        f2.write(re.sub(r'^' + delete, '', line))
                os.remove(realpath)
                os.rename("%s.bak" % realpath, realpath)
        except Exception as e:
            print("--错误原因", e)
            return 0


if __name__ == "__main__":
    # re = CommonMethod.checkServerReachable("90.90.64.110", "root", "huawei")
    # print(re)

    cr = ConfigReader("test")
    cr.getConfig()
    cr.parseOutput()

    re = RemoteExecute("90.90.64.118", "root", "huawei")
    re.uploadallScript("/root/scripts", "scripts")
    # re.exec_remote_cmd("sh /root/scripts/install_all.sh")
    re.close()