#! /bin/bash
# 软中断绑定
SCRIPT_HOME=$(cd $(dirname $0)/; pwd)
source $SCRIPT_HOME/para.cfg

function is_digital()
{
	expr $1 "+" 10 &> /dev/null
	if [ $? -ne 0 ]; then
		return 1
	else
		return 0
	fi
}

function get_irq_affi_str()
{
	irq_idx=$1
	expr $irq_idx "+" 10 &> /dev/null+
	if [ $? -ne 0 ]; then
		echo "Please input an number($irq_idx)"
		exit 1
	fi

	irq_split=32
	irq_tmp_idx=$(($irq_idx%$irq_split))
	irq_tmp_split=$(($irq_idx/$irq_split))

	irq_tmp=$((2**$irq_tmp_idx))
	# 输出变量irq_temp的十六进制(8位数0占位)
	irq_affi_tmp=`printf "%08x" $irq_tmp`

	irq_affi=
	affi_zero=`printf "%08x" 0`
	for((i=1; i<=$irq_tmp_split; i++))
	do
		irq_affi=','${affi_zero}${irq_affi}
	done

	irq_affi=${irq_affi_tmp}${irq_affi}
	
	echo $irq_affi
}


# para1 is the array of irq_idx to set irq affi
function set_irqs_affi()
{
	irq_arr=($1)
	cpu_arr=($2)
	
	# 判断数组长度
	cpu_num=${#cpu_arr[@]}
	idx=0
	for irq in ${irq_arr[*]}; do
		cpu_idx=${cpu_arr[$idx]}
		# 如果cpu_num数组中只有一个元素，每次循环的cpu_idx就获取该元素
		let idx=idx+1
		if [ "$idx" -eq "$cpu_num" ]; then
				idx=0
		fi

		# 00000000
		irq_affi_str=`get_irq_affi_str $cpu_idx`
		# 00000000,00000000,00ffffff
		affi_file="/proc/irq/$irq/smp_affinity"
		# [ ! -e xxx ]表示文件不存在
		if [ ! -e "$affi_file" ]; then
			echo "can not find irq$irq"
			continue
		fi

		echo $irq_affi_str > $affi_file
		echo "set irq $irq to cpu $cpu_idx, affi: `cat $affi_file`"	
	done
}

function setIrq()
{
  # 获取NUMA node总数
  num_numa_node=`lscpu | grep "NUMA node(s):" | awk '{print $NF}'`
  # 获取CPU总数
  num_cpus=`lscpu | grep "^CPU(s)" | awk '{print $NF}'`


  #set netdevice name but numa node not setted, get numa node from netdevice
  if [ "$dev_name" != "all" ]; then
    if [ "$numa_node" == "" ]; then
      numa_node=`cat /sys/class/net/$dev_name/device/numa_node`
    fi
  fi

  echo "set device: [$dev_name] irqs to numa node: [$numa_node], match-str: $match_str, cpu-range: $cpu_range"

  if [ "$cpu_range" == "" ] && [ "$cpu_range" != "all" ]; then
    if [ "$numa_node" != "" ]; then
      # 获取传入的numa_node对应的CPUcore情况
      cpu_range=`lscpu | grep "NUMA node$numa_node" | awk '{print $NF}'`
    else
      cpu_range=`echo "0-$(($num_cpus-1))"`
    fi
  elif [ "$cpu_range" == "all" ]; then
    cpu_range=`echo "0-$(($num_cpus-1))"`
  fi

  cpu_idx_arr=()
  tmp_range_arr=`echo $cpu_range | awk -F ',' '{for(i=1;i<=NF;i++) print $i}'`
  for cpu_tmp_range in ${tmp_range_arr[*]}
  do
    # 获取对应的起始和终点core
    cpu_start=`echo $cpu_tmp_range | awk -F '-' '{print $1}'`
    cpu_end=`echo $cpu_tmp_range | awk -F '-' '{print $2}'`
    # seq num1 num2表示生成从num1到num2之间的所有整数
    tmp_arr=`seq $cpu_start $cpu_end`
    cpu_idx_arr=(${cpu_idx_arr[@]} ${tmp_arr[@]})
  done


  if [ "$match_str" != "" ]; then
    # 获取对应的irq
    irq_arr=`cat /proc/interrupts | grep -E "$match_str" | awk -F ':' '{print $1}' | sed 's/[[:space:]]//g'`
  else
    #default irqs, get all interrupts named with "qp"
    if [ $dev_name != "all" ]; then
      irq_arr=`cat /proc/interrupts | grep -E "$dev_name" | awk -F ":" '{print $1}' | sed 's/[[:space:]]//g'`
    else
      irq_arr=`cat /proc/interrupts | grep qp | awk -F ":" '{print $1}' | sed 's/[[:space:]]//g'`
    fi
  fi

  set_irqs_affi "${irq_arr[*]}" "${cpu_idx_arr[*]}"
}
