#!/bin/bash
# PG分布调优
SCRIPT_HOME=$(cd $(dirname $0)/; pwd)
source $SCRIPT_HOME/para.cfg

function is_digital()
{
	expr $1 "+" 10 &> /dev/null
        if [ $? -ne 0 ]; then
            return 1
        else
            return 0
        fi
}

function change_softlink()
{
    path=`pwd`
    # 切换工作目录
    cd /usr/lib64
    # 删除原来软连接
    rm -rf libstdc++.so.6
    # 将默认库的软连接指向最新动态库
    ln -s $path/libstdc++.so.6.0.24 libstdc++.so.6
}

# PG优化
function pgOptimization()
{
    ceph balancer mode upmap
    ceph balancer on
    res=`ceph balancer status | grep active | grep true`
    if [ "$res" != "" ];then
        echo "Ceph Balancer is ON"
    else
        echo "Ceph Balancer is not ON"
        return 1
    fi
}

# 主PG分布优化
function primaryPgOptimization()
{
    is_digital $hostnum
    if [ $? -ne 0 ];then
        echo "Invalid hostnum($hostnum), please input a digital of hostnum"
        exit 1
    fi

    is_digital $osdperhost
    if [ $? -ne 0 ];then
        echo "Invalid osdperhost($osdperhost), please input a digital of osdperhost"
        exit 1
    fi
    # 在ceph集群生成pgmap文件
    ceph pg dump pgs | awk '{print $1,$17}' > $SCRIPT_HOME/pgmap
    # 生成优化脚本
    $SCRIPT_HOME/primaypgbalancer-opt $SCRIPT_HOME/pgmap $hostnum $osdperhost
    # 如果使用生成脚本工具出现指定错误，则修改软连接再试;如果不是指定错误，则终止运行，输出错误信息
    if [ $? -ne 0 ];then
        err=$($SCRIPT_HOME/primaypgbalancer-opt $SCRIPT_HOME/pgmap $hostnum $osdperhost}2>&1)
        error="/usr/lib64/libstdc++.so.6: version 'GLIBCXX_3.4.21' not found"
        # err包含error
        if [[ "$err" =~ "$error" ]];then
            change_softlink
            $SCRIPT_HOME/primaypgbalancer-opt $SCRIPT_HOME/pgmap $hostnum $osdperhost
        else
            echo $err
            return 1
        fi
    fi
    # 成功的话执行优化脚本
    chmod 755 pgmap-x86-2.sh
    sh ./pgmap-x86-2.sh
}
