#!/bin/bash

# 检查/etc/sysctl.conf里是否已存在vm.swappiess=语句，如果存在则先注释再追加
function checkswapexist()
{
    find_res=$(cat /etc/sysctl.conf | grep -E "^vm.swappiness=")
    if [ "$find_res" != "" ];then
        for i in $find_res;do
            sed -i "s/^$i/#&/" /etc/sysctl.conf
        done
    fi
    echo "vm.swappiness=$1" >> /etc/sysctl.conf
}

function SetTempSwappiness()
{
    # 默认值为0
    swap=${1:-'0'}
    # 如果传参先判断参数是否有效
    if [ ! $(grep '^[[:digit:]]*$' <<< $swap) ];then
        log "ERROR: Swappiness parameter is invalid" error
        return 1
    fi
    sudo sysctl vm.swappiness=$swap
    # 判断是否修改成功
    if [ $(cat /proc/sys/vm/swappiness) -eq $swap ];then
        log "Set vm:swappiness: $swap    [OK]" warn
        return 0
    else
        log "ERROR: Set vm:swappiness Fail" error
        return 1
    fi
}

function SetPersistentSwappiness()
{
    swap=$1
    # 判断是否传参以及参数是否有效，如果没有则提示错误
    if [ ! $swap ] || [ ! $(grep '^[[:digit:]]*$' <<< $swap) ];then
        log "ERROR: Swappiness Need a valid parameter" error
        return 1
    fi
    checkswapexist $swap
    sysctl -p >/dev/null
    # 判断是否修改成功
    if [ $(cat /proc/sys/vm/swappiness) -eq $swap ];then
        log "Set vm:swappiness: $swap    [OK]" warn
        return 0
    else
        log "ERROR: Set vm:swappiness Fail" error
        return 1
    fi
}
